"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YOU_ARE_A_HELPFUL_EXPERT_ASSISTANT = exports.USE_THE_FOLLOWING_CONTEXT_TO_ANSWER = exports.SYSTEM_PROMPT_CONTEXT_NON_I18N = exports.SUPERHERO_SYSTEM_PROMPT_NON_I18N = exports.SUPERHERO_SYSTEM_PROMPT_NAME = exports.SUPERHERO_PERSONALITY = exports.IF_YOU_DONT_KNOW_THE_ANSWER = exports.FORMAT_OUTPUT_CORRECTLY = exports.DEFAULT_SYSTEM_PROMPT_NON_I18N = exports.DEFAULT_SYSTEM_PROMPT_NAME = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const YOU_ARE_A_HELPFUL_EXPERT_ASSISTANT = exports.YOU_ARE_A_HELPFUL_EXPERT_ASSISTANT = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.system.youAreAHelpfulExpertAssistant', {
  defaultMessage: 'You are a helpful, expert assistant who answers questions about Elastic Security.'
});
const USE_THE_FOLLOWING_CONTEXT_TO_ANSWER = exports.USE_THE_FOLLOWING_CONTEXT_TO_ANSWER = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.system.useTheFollowingContextToAnswer', {
  defaultMessage: 'Use the following context to answer questions:'
});
const IF_YOU_DONT_KNOW_THE_ANSWER = exports.IF_YOU_DONT_KNOW_THE_ANSWER = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.system.ifYouDontKnowTheAnswer', {
  defaultMessage: 'Do not answer questions unrelated to Elastic Security.'
});
const SUPERHERO_PERSONALITY = exports.SUPERHERO_PERSONALITY = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.system.superheroPersonality', {
  defaultMessage: 'Provide the most detailed and relevant answer possible, as if you were relaying this information back to a cyber security expert.'
});
const FORMAT_OUTPUT_CORRECTLY = exports.FORMAT_OUTPUT_CORRECTLY = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.system.outputFormatting', {
  defaultMessage: 'If you answer a question related to KQL, EQL, or ES|QL, it should be immediately usable within an Elastic Security timeline; please always format the output correctly with back ticks. Any answer provided for Query DSL should also be usable in a security timeline. This means you should only ever include the "filter" portion of the query.'
});
const DEFAULT_SYSTEM_PROMPT_NON_I18N = exports.DEFAULT_SYSTEM_PROMPT_NON_I18N = `${YOU_ARE_A_HELPFUL_EXPERT_ASSISTANT} ${IF_YOU_DONT_KNOW_THE_ANSWER}
${FORMAT_OUTPUT_CORRECTLY}
${USE_THE_FOLLOWING_CONTEXT_TO_ANSWER}`;
const DEFAULT_SYSTEM_PROMPT_NAME = exports.DEFAULT_SYSTEM_PROMPT_NAME = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.system.defaultSystemPromptName', {
  defaultMessage: 'Default system prompt'
});
const SUPERHERO_SYSTEM_PROMPT_NON_I18N = exports.SUPERHERO_SYSTEM_PROMPT_NON_I18N = `${YOU_ARE_A_HELPFUL_EXPERT_ASSISTANT} ${IF_YOU_DONT_KNOW_THE_ANSWER}
${SUPERHERO_PERSONALITY}
${FORMAT_OUTPUT_CORRECTLY}
${USE_THE_FOLLOWING_CONTEXT_TO_ANSWER}`;
const SUPERHERO_SYSTEM_PROMPT_NAME = exports.SUPERHERO_SYSTEM_PROMPT_NAME = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.system.superheroSystemPromptName', {
  defaultMessage: 'Enhanced system prompt'
});
const SYSTEM_PROMPT_CONTEXT_NON_I18N = context => {
  return `CONTEXT:\n"""\n${context}\n"""`;
};
exports.SYSTEM_PROMPT_CONTEXT_NON_I18N = SYSTEM_PROMPT_CONTEXT_NON_I18N;