"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withNavigationProvider = exports.getSolutionNavigation = void 0;
var _react = _interopRequireDefault(require("react"));
var _panel = require("@kbn/security-solution-side-nav/panel");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _use_panel_side_nav_items = require("./use_panel_side_nav_items");
var _categories = require("./categories");
var _navigation_tree = require("./navigation_tree");
var _nav_links = require("../../common/links/nav_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const withNavigationProvider = (Component, core) => function WithNavigationProvider(props) {
  return /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: core
  }, /*#__PURE__*/_react.default.createElement(Component, props));
};
exports.withNavigationProvider = withNavigationProvider;
const getPanelContent = (core, solutionNavLinks$) => {
  const PanelContentProvider = /*#__PURE__*/_react.default.memo(function PanelContentProvider({
    selectedNode: {
      id: linkId
    },
    closePanel
  }) {
    const solutionNavLinks = (0, _useObservable.default)(solutionNavLinks$, []);
    const currentPanelItem = solutionNavLinks.find(item => item.id === linkId);
    const {
      title = '',
      links = [],
      categories
    } = currentPanelItem !== null && currentPanelItem !== void 0 ? currentPanelItem : {};
    const items = (0, _use_panel_side_nav_items.usePanelSideNavItems)(links);
    if (items.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_panel.SolutionSideNavPanelContent, {
      title: title,
      items: items,
      categories: categories,
      onClose: closePanel
    });
  });
  return withNavigationProvider(PanelContentProvider, core);
};
const getSolutionNavigation = core => {
  const panelContent = getPanelContent(core, _nav_links.navLinks$);
  const panelContentProvider = id => {
    // Stack Management uses the default panel content
    if (!id.endsWith('.stack_management')) {
      return {
        content: panelContent
      };
    }
  };
  const navigationTree$ = _nav_links.navLinks$.pipe((0, _rxjs.map)(solutionNavLinks => (0, _navigation_tree.formatNavigationTree)(solutionNavLinks, _categories.CATEGORIES, _categories.FOOTER_CATEGORIES)));
  return {
    navigationTree$,
    panelContentProvider
  };
};
exports.getSolutionNavigation = getSolutionNavigation;