"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconVisualizationLazy = exports.IconTimelineLazy = exports.IconSettingsLazy = exports.IconReplicationLazy = exports.IconRapidBarGraphLazy = exports.IconOsqueryLazy = exports.IconMarketingLazy = exports.IconManagerLazy = exports.IconLensLazy = exports.IconKeywordLazy = exports.IconJobsLazy = exports.IconIntuitiveLazy = exports.IconInfraLazy = exports.IconFleetLazy = exports.IconFilebeatLazy = exports.IconFilebeatChartLazy = exports.IconEndpointLazy = exports.IconEcctlLazy = exports.IconDataViewLazy = exports.IconDashboardLazy = exports.IconChartArrowLazy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const withSuspenseIcon = Component => function WithSuspenseIcon(props) {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    })
  }, /*#__PURE__*/_react.default.createElement(Component, props));
};
const IconLensLazy = exports.IconLensLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/lens')))));
const IconEndpointLazy = exports.IconEndpointLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/endpoint')))));
const IconFleetLazy = exports.IconFleetLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/fleet')))));
const IconEcctlLazy = exports.IconEcctlLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/ecctl')))));
const IconTimelineLazy = exports.IconTimelineLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/timeline')))));
const IconOsqueryLazy = exports.IconOsqueryLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/osquery')))));
const IconVisualizationLazy = exports.IconVisualizationLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/visualization')))));
const IconMarketingLazy = exports.IconMarketingLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/marketing')))));
const IconInfraLazy = exports.IconInfraLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/infra')))));
const IconKeywordLazy = exports.IconKeywordLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/keyword')))));
const IconJobsLazy = exports.IconJobsLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/jobs')))));
const IconSettingsLazy = exports.IconSettingsLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/settings')))));
const IconDashboardLazy = exports.IconDashboardLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/dashboard')))));
const IconChartArrowLazy = exports.IconChartArrowLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/chart_arrow')))));
const IconManagerLazy = exports.IconManagerLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/manager')))));
const IconFilebeatLazy = exports.IconFilebeatLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/filebeat')))));
const IconDataViewLazy = exports.IconDataViewLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/data_view')))));
const IconReplicationLazy = exports.IconReplicationLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/replication')))));
const IconIntuitiveLazy = exports.IconIntuitiveLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/intuitive')))));
const IconRapidBarGraphLazy = exports.IconRapidBarGraphLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/rapid_bar_graph')))));
const IconFilebeatChartLazy = exports.IconFilebeatChartLazy = withSuspenseIcon( /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./icons/filebeat_chart')))));