"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.investigationsNavLinks = exports.createInvestigationsLinkFromTimeline = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../../../../../common/constants");
var _common = require("../../../../../common");
var _lazy_icons = require("./lazy_icons");
var i18n = _interopRequireWildcard(require("./investigations_translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// appLinks configures the Security Solution pages links
const investigationsAppLink = {
  id: _securitySolutionNavigation.SecurityPageName.investigations,
  title: i18n.INVESTIGATIONS_TITLE,
  path: _constants.INVESTIGATIONS_PATH,
  capabilities: [`${_common.SERVER_APP_ID}.show`],
  hideTimeline: true,
  skipUrlState: true,
  links: [] // timeline link are added in createInvestigationsLinkFromTimeline
};
const createInvestigationsLinkFromTimeline = timelineLink => {
  return {
    ...investigationsAppLink,
    links: [{
      ...timelineLink,
      description: i18n.TIMELINE_DESCRIPTION,
      landingIcon: _lazy_icons.IconTimelineLazy
    }]
  };
};

// navLinks define the navigation links for the Security Solution pages and External pages as well
exports.createInvestigationsLinkFromTimeline = createInvestigationsLinkFromTimeline;
const investigationsNavLinks = exports.investigationsNavLinks = [{
  id: _securitySolutionNavigation.ExternalPageName.osquery,
  title: i18n.OSQUERY_TITLE,
  landingIcon: _lazy_icons.IconOsqueryLazy,
  description: i18n.OSQUERY_DESCRIPTION
}];