"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.solutionAppLinksSwitcher = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _lodash = require("lodash");
var _investigations_links = require("./sections/investigations_links");
var _ml_links = require("./sections/ml_links");
var _assets_links = require("./sections/assets_links");
var _settings_links = require("./sections/settings_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This function is called by the security_solution plugin to alter the app links
// that will be registered to the Security Solution application using the new "solution-centric" IA.
// The capabilities filtering is done after this function is called by the security_solution plugin.
// TODO: remove after rollout https://github.com/elastic/kibana/issues/179572
const solutionAppLinksSwitcher = appLinks => {
  const solutionAppLinks = (0, _lodash.cloneDeep)(appLinks);

  // Remove timeline link
  const [timelineLinkItem] = (0, _lodash.remove)(solutionAppLinks, {
    id: _securitySolutionNavigation.SecurityPageName.timelines
  });
  if (timelineLinkItem) {
    solutionAppLinks.push((0, _investigations_links.createInvestigationsLinkFromTimeline)(timelineLinkItem));
  }

  // Remove data quality dashboard link
  const dashboardLinkItem = (0, _lodash.find)(solutionAppLinks, {
    id: _securitySolutionNavigation.SecurityPageName.dashboards
  });
  if (dashboardLinkItem && dashboardLinkItem.links) {
    (0, _lodash.remove)(dashboardLinkItem.links, {
      id: _securitySolutionNavigation.SecurityPageName.dataQuality
    });
  }

  // Remove manage link
  const [manageLinkItem] = (0, _lodash.remove)(solutionAppLinks, {
    id: _securitySolutionNavigation.SecurityPageName.administration
  });
  if (manageLinkItem) {
    solutionAppLinks.push((0, _assets_links.createAssetsLinkFromManage)(manageLinkItem));
    solutionAppLinks.push(...(0, _settings_links.createSettingsLinksFromManage)(manageLinkItem));
  }

  // Add ML link
  solutionAppLinks.push(_ml_links.mlAppLink);
  return Object.freeze(solutionAppLinks);
};
exports.solutionAppLinksSwitcher = solutionAppLinksSwitcher;