"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FOOTER_CATEGORIES = exports.CATEGORIES = void 0;
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CATEGORIES = exports.CATEGORIES = [{
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.ExternalPageName.discover, _securitySolutionNavigation.SecurityPageName.dashboards]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.rulesLanding, _securitySolutionNavigation.SecurityPageName.alerts, _securitySolutionNavigation.SecurityPageName.attackDiscovery, _securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings, _securitySolutionNavigation.SecurityPageName.case]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.investigations, _securitySolutionNavigation.SecurityPageName.threatIntelligence, _securitySolutionNavigation.SecurityPageName.exploreLanding]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.assets]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.mlLanding]
},
// --- Hidden links that need to be configured in the navigationTree for breadcrumbs ---
{
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement] // Linked from the management cards landing.
}];
const FOOTER_CATEGORIES = exports.FOOTER_CATEGORIES = [{
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.landing, _securitySolutionNavigation.ExternalPageName.devTools]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.accordion,
  label: _i18n.i18n.translate('xpack.securitySolution.navCategory.management.title', {
    defaultMessage: 'Management'
  }),
  iconType: 'gear',
  linkIds: [_securitySolutionNavigation.ExternalPageName.management, _securitySolutionNavigation.ExternalPageName.integrationsSecurity]
}];