"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRedux = require("react-redux");
var _constants = require("../../common/constants");
var _route_capture = require("../common/components/endpoint/route_capture");
var _kibana = require("../common/lib/kibana");
var _manage_spy_routes = require("../common/utils/route/manage_spy_routes");
var _ = require("./404");
var _home = require("./home");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageRouterComponent = ({
  children,
  history
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const CasesContext = cases.ui.getCasesContext();
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    return () => {
      // When app is dismounted via a non-router method (ex. using Kibana's `services.application.navigateToApp()`)
      // ensure that one last `userChangedUrl` store action is dispatched, which will help trigger state reset logic
      dispatch({
        type: 'userChangedUrl',
        payload: {
          pathname: '',
          search: '',
          hash: ''
        }
      });
    };
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_manage_spy_routes.ManageRoutesSpy, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_route_capture.RouteCapture, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [_constants.APP_ID],
    permissions: userCasesPermissions
  }, /*#__PURE__*/_react.default.createElement(_home.HomePage, null, children))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_.NotFoundPage, null))))));
};
const PageRouter = exports.PageRouter = /*#__PURE__*/(0, _react.memo)(PageRouterComponent);