"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionTemplateWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _tour = require("../../../attack_discovery/tour");
var _use_url_state = require("../../../common/hooks/use_url_state");
var _flyout = require("../../../flyout");
var _use_security_solution_navigation = require("../../../common/components/navigation/use_security_solution_navigation");
var _timeline = require("../../../../common/types/timeline");
var _selectors = require("../../../timelines/store/selectors");
var _use_selector = require("../../../common/hooks/use_selector");
var _global_kql_header = require("./global_kql_header");
var _timeline2 = require("./timeline");
var _use_show_timeline = require("../../../common/utils/timeline/use_show_timeline");
var _use_route_spy = require("../../../common/utils/route/use_route_spy");
var _types = require("../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Need to apply the styles via a className to effect the containing bottom bar
 * rather than applying them to the timeline bar directly
 */
const StyledKibanaPageTemplate = (0, _styledComponents.default)(_sharedUxPageKibanaTemplate.KibanaPageTemplate)`
  .kbnSolutionNav__sidebar:not(.kbnSolutionNav__sidebar--shrink) {
    background-color: ${({
  theme
}) => theme.colors.emptyShade};
  }

    .${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} & {
      // When a drag is in process the bottom flyout should slide up to allow a drop
      transform: none;
    }
  }
`;
const SecuritySolutionTemplateWrapper = exports.SecuritySolutionTemplateWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  ...rest
}) => {
  var _rest$paddingSize;
  const [didMount, setDidMount] = (0, _react.useState)(false);
  const onMount = (0, _react.useCallback)(() => {
    setDidMount(true);
  }, []);
  const solutionNavProps = (0, _use_security_solution_navigation.useSecuritySolutionNavigation)(onMount);
  const [isTimelineBottomBarVisible] = (0, _use_show_timeline.useShowTimeline)();
  const getTimelineShowStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineShowStatusByIdSelector)(), []);
  const {
    show: isShowingTimelineOverlay
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineShowStatus(state, _timeline.TimelineId.active));
  const [routeProps] = (0, _use_route_spy.useRouteSpy)();
  const isPreview = (routeProps === null || routeProps === void 0 ? void 0 : routeProps.pageName) === _types.SecurityPageName.rulesCreate;

  // The bottomBar by default has a set 'dark' colorMode that doesn't match the global colorMode from the Advanced Settings
  // To keep the mode in sync, we pass in the globalColorMode to the bottom bar here
  const {
    euiTheme,
    colorMode: globalColorMode
  } = (0, _eui.useEuiTheme)();

  // There is some logic in the StyledKibanaPageTemplate that checks for children presence, and we dont even need to render the children
  // here if isEmptyState is set
  const isNotEmpty = !rest.isEmptyState;

  /*
   * StyledKibanaPageTemplate is a styled EuiPageTemplate. Security solution currently passes the header
   * and page content as the children of StyledKibanaPageTemplate, as opposed to using the pageHeader prop,
   * which may account for any style discrepancies, such as the bottom border not extending the full width of the page,
   * between EuiPageTemplate and the security solution pages.
   */
  return /*#__PURE__*/_react.default.createElement(StyledKibanaPageTemplate, (0, _extends2.default)({
    theme: euiTheme,
    $isShowingTimelineOverlay: isShowingTimelineOverlay,
    paddingSize: "none",
    solutionNav: solutionNavProps,
    restrictWidth: false
  }, rest), isNotEmpty && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_global_kql_header.GlobalKQLHeader, null), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    className: "securityPageWrapper",
    "data-test-subj": "pageContainer",
    paddingSize: (_rest$paddingSize = rest.paddingSize) !== null && _rest$paddingSize !== void 0 ? _rest$paddingSize : 'l',
    alignment: "top",
    component: "div",
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyoutProvider, {
    urlKey: isPreview ? undefined : _use_url_state.URL_PARAM_KEY.flyout
  }, children, /*#__PURE__*/_react.default.createElement(_flyout.SecuritySolutionFlyout, null)), didMount && /*#__PURE__*/_react.default.createElement(_tour.AttackDiscoveryTour, null)), isTimelineBottomBarVisible && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    "data-test-subj": "timeline-bottom-bar-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: globalColorMode
  }, /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyoutProvider, {
    urlKey: _use_url_state.URL_PARAM_KEY.timelineFlyout
  }, /*#__PURE__*/_react.default.createElement(_timeline2.Timeline, null), /*#__PURE__*/_react.default.createElement(_flyout.TimelineFlyout, null))))));
});
SecuritySolutionTemplateWrapper.displayName = 'SecuritySolutionTemplateWrapper';