"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopValuesPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _reactUse = require("react-use");
var _top_n = require("../../../common/components/top_n");
var _sourcerer = require("../../../common/containers/sourcerer");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopValuesPopover = exports.TopValuesPopover = /*#__PURE__*/_react.default.memo(() => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    browserFields,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)((0, _sourcerer.getScopeFromPath)(pathname));
  const {
    services: {
      topValuesPopover
    }
  } = (0, _kibana.useKibana)();
  const data = (0, _reactUse.useObservable)(topValuesPopover.getObservable());
  const onClose = (0, _react.useCallback)(() => {
    topValuesPopover.closePopover();
  }, [topValuesPopover]);
  if (!data || !data.nodeRef) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: true,
    button: data.nodeRef,
    closePopover: onClose,
    anchorPosition: 'downCenter',
    hasArrow: false,
    repositionOnScroll: true,
    ownFocus: true,
    attachToAnchor: false
  }, /*#__PURE__*/_react.default.createElement(_top_n.StatefulTopN, {
    field: data.fieldName,
    showLegend: true,
    scopeId: data.scopeId,
    toggleTopN: onClose,
    indexPattern: indexPattern,
    browserFields: browserFields
  }));
});
TopValuesPopover.displayName = 'TopValuesPopover';