"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingPageService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OnboardingPageService {
  constructor() {
    (0, _defineProperty2.default)(this, "productTypesSubject$", void 0);
    (0, _defineProperty2.default)(this, "projectsUrlSubject$", void 0);
    (0, _defineProperty2.default)(this, "projectFeaturesUrlSubject$", void 0);
    (0, _defineProperty2.default)(this, "availableStepsSubject$", void 0);
    (0, _defineProperty2.default)(this, "productTypes$", void 0);
    (0, _defineProperty2.default)(this, "projectsUrl$", void 0);
    (0, _defineProperty2.default)(this, "projectFeaturesUrl$", void 0);
    (0, _defineProperty2.default)(this, "availableSteps$", void 0);
    this.productTypesSubject$ = new _rxjs.BehaviorSubject(undefined);
    this.projectsUrlSubject$ = new _rxjs.BehaviorSubject(undefined);
    this.projectFeaturesUrlSubject$ = new _rxjs.BehaviorSubject(undefined);
    this.availableStepsSubject$ = new _rxjs.BehaviorSubject([]);
    this.productTypes$ = this.productTypesSubject$.asObservable();
    this.projectsUrl$ = this.projectsUrlSubject$.asObservable();
    this.projectFeaturesUrl$ = this.projectFeaturesUrlSubject$.asObservable();
    this.availableSteps$ = this.availableStepsSubject$.asObservable();
  }
  setProductTypes(productTypes) {
    this.productTypesSubject$.next(productTypes);
  }
  setProjectFeaturesUrl(projectFeaturesUrl) {
    this.projectFeaturesUrlSubject$.next(projectFeaturesUrl);
  }
  setProjectsUrl(projectsUrl) {
    this.projectsUrlSubject$.next(projectsUrl);
  }
  setAvailableSteps(availableSteps) {
    this.availableStepsSubject$.next(availableSteps);
  }
}
exports.OnboardingPageService = OnboardingPageService;