"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDiscoverHistogramActions = void 0;
var _public = require("@kbn/unified-search-plugin/public");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDiscoverHistogramCustomFilterAction = (store, history, services) => {
  const histogramApplyFilter = (0, _public.createFilterAction)(services.customDataService.query.filterManager, services.customDataService.query.timefilter.timefilter, services.theme, _constants.EsqlInTimelineAction.VIS_FILTER_ACTION, _constants.EsqlInTimelineAction.VIS_FILTER_ACTION);
  services.uiActions.registerAction(histogramApplyFilter);
  return histogramApplyFilter;
};
const createDiscoverHistogramCustomTrigger = (store, history, services) => {
  services.uiActions.registerTrigger({
    id: _constants.EsqlInTimelineTrigger.HISTOGRAM_TRIGGER
  });
};
const registerDiscoverHistogramActions = (store, history, services) => {
  createDiscoverHistogramCustomTrigger(store, history, services);
  const histogramApplyFilter = createDiscoverHistogramCustomFilterAction(store, history, services);
  services.uiActions.attachAction(_constants.EsqlInTimelineTrigger.HISTOGRAM_TRIGGER, histogramApplyFilter.id);
};
exports.registerDiscoverHistogramActions = registerDiscoverHistogramActions;