"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEVERITY = exports.INVESTIGATE_IN_TIMELINE = exports.ALERTS_COUNT = exports.ADD_TO_TIMELINE_SUCCESS_TITLE = exports.ADD_TO_TIMELINE_ICON = exports.ADD_TO_TIMELINE_FAILED_TITLE = exports.ADD_TO_TIMELINE_FAILED_TEXT = exports.ADD_TO_TIMELINE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_TIMELINE_ICON = exports.ADD_TO_TIMELINE_ICON = 'timeline';
const ADD_TO_TIMELINE = exports.ADD_TO_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.actions.cellValue.addToTimeline.displayName', {
  defaultMessage: 'Add to timeline'
});
const INVESTIGATE_IN_TIMELINE = exports.INVESTIGATE_IN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.actions.cellValue.addToNewTimeline.displayName', {
  defaultMessage: 'Investigate in timeline'
});
const SEVERITY = level => _i18n.i18n.translate('xpack.securitySolution.actions.addToTimeline.severityLevel', {
  values: {
    level
  },
  defaultMessage: `{level} severity`
});
exports.SEVERITY = SEVERITY;
const ALERTS_COUNT = (entity, description) => description !== '' ? _i18n.i18n.translate('xpack.securitySolution.actions.addToTimeline.descriptiveAlertsCountMessage', {
  values: {
    description,
    entity
  },
  defaultMessage: '{description} alerts from {entity}'
}) : _i18n.i18n.translate('xpack.securitySolution.actions.addToTimeline.alertsCountMessage', {
  values: {
    entity
  },
  defaultMessage: '{entity} alerts'
});
exports.ALERTS_COUNT = ALERTS_COUNT;
const ADD_TO_TIMELINE_SUCCESS_TITLE = value => _i18n.i18n.translate('xpack.securitySolution.actions.addToTimeline.addedFieldMessage', {
  values: {
    fieldOrValue: value
  },
  defaultMessage: `Added {fieldOrValue} to timeline`
});
exports.ADD_TO_TIMELINE_SUCCESS_TITLE = ADD_TO_TIMELINE_SUCCESS_TITLE;
const ADD_TO_TIMELINE_FAILED_TITLE = exports.ADD_TO_TIMELINE_FAILED_TITLE = _i18n.i18n.translate('xpack.securitySolution.actions.cellValue.addToTimeline.warningTitle', {
  defaultMessage: 'Unable to add to timeline'
});
const ADD_TO_TIMELINE_FAILED_TEXT = exports.ADD_TO_TIMELINE_FAILED_TEXT = _i18n.i18n.translate('xpack.securitySolution.actions.cellValue.addToTimeline.warningMessage', {
  defaultMessage: 'Filter received is empty or cannot be added to timeline'
});