"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  TimelineTabs: true,
  TimelineId: true
};
exports.TimelineTabs = exports.TimelineId = void 0;
var _cells = require("./cells");
Object.keys(_cells).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _cells[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _cells[key];
    }
  });
});
var _columns = require("./columns");
Object.keys(_columns).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _columns[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _columns[key];
    }
  });
});
var _data_provider = require("./data_provider");
Object.keys(_data_provider).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _data_provider[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _data_provider[key];
    }
  });
});
var _rows = require("./rows");
Object.keys(_rows).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _rows[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _rows[key];
    }
  });
});
var _store = require("./store");
Object.keys(_store).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _store[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _store[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Used for scrolling top inside a tab. Especially when swiching tabs.
 */
let TimelineTabs = exports.TimelineTabs = /*#__PURE__*/function (TimelineTabs) {
  TimelineTabs["query"] = "query";
  TimelineTabs["graph"] = "graph";
  TimelineTabs["notes"] = "notes";
  TimelineTabs["pinned"] = "pinned";
  TimelineTabs["eql"] = "eql";
  TimelineTabs["session"] = "session";
  TimelineTabs["securityAssistant"] = "securityAssistant";
  TimelineTabs["esql"] = "esql";
  return TimelineTabs;
}({});
/*
 *  Timeline IDs
 */
let TimelineId = exports.TimelineId = /*#__PURE__*/function (TimelineId) {
  TimelineId["active"] = "timeline-1";
  TimelineId["casePage"] = "timeline-case";
  TimelineId["test"] = "timeline-test";
  return TimelineId;
}({}); // Reserved for testing purposes