"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskWeightsSchema = exports.riskWeightSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _utils = require("../utils");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostWeight = t.type({
  host: _securitysolutionIoTsTypes.NumberBetweenZeroAndOneInclusive
});
const userWeight = t.type({
  user: _securitysolutionIoTsTypes.NumberBetweenZeroAndOneInclusive
});
const identifierWeights = t.union([t.exact(t.intersection([hostWeight, userWeight])), t.exact(t.intersection([hostWeight, t.partial({
  user: t.undefined
})])), t.exact(t.intersection([userWeight, t.partial({
  host: t.undefined
})]))]);
const riskCategories = (0, _utils.fromEnum)('riskCategories', _types.RiskCategories);
const globalRiskWeightSchema = t.intersection([t.exact(t.type({
  type: t.literal(_types.RiskWeightTypes.global)
})), identifierWeights]);
const riskCategoryRiskWeightSchema = t.intersection([t.exact(t.type({
  type: t.literal(_types.RiskWeightTypes.riskCategory),
  value: riskCategories
})), identifierWeights]);
const riskWeightSchema = exports.riskWeightSchema = t.union([globalRiskWeightSchema, riskCategoryRiskWeightSchema]);
const riskWeightsSchema = exports.riskWeightsSchema = t.array(riskWeightSchema);