"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskLevel = exports.RISK_LEVEL_RANGES = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_LEVEL_RANGES = exports.RISK_LEVEL_RANGES = {
  [_types.RiskLevels.unknown]: {
    start: 0,
    stop: 20
  },
  [_types.RiskLevels.low]: {
    start: 20,
    stop: 40
  },
  [_types.RiskLevels.moderate]: {
    start: 40,
    stop: 70
  },
  [_types.RiskLevels.high]: {
    start: 70,
    stop: 90
  },
  [_types.RiskLevels.critical]: {
    start: 90,
    stop: 100
  }
};
const getRiskLevel = riskScore => {
  if (riskScore >= RISK_LEVEL_RANGES[_types.RiskLevels.critical].start) {
    return _types.RiskLevels.critical;
  } else if (riskScore >= RISK_LEVEL_RANGES[_types.RiskLevels.high].start) {
    return _types.RiskLevels.high;
  } else if (riskScore >= RISK_LEVEL_RANGES[_types.RiskLevels.moderate].start) {
    return _types.RiskLevels.moderate;
  } else if (riskScore >= RISK_LEVEL_RANGES[_types.RiskLevels.low].start) {
    return _types.RiskLevels.low;
  } else {
    return _types.RiskLevels.unknown;
  }
};
exports.getRiskLevel = getRiskLevel;