"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RISK_SCORE_INDEX_PATTERN = exports.RISK_ENGINE_URL = exports.RISK_ENGINE_STATUS_URL = exports.RISK_ENGINE_SETTINGS_URL = exports.RISK_ENGINE_REQUIRED_ES_INDEX_PRIVILEGES = exports.RISK_ENGINE_REQUIRED_ES_CLUSTER_PRIVILEGES = exports.RISK_ENGINE_PRIVILEGES_URL = exports.RISK_ENGINE_INIT_URL = exports.RISK_ENGINE_ENABLE_URL = exports.RISK_ENGINE_DISABLE_URL = exports.MAX_SPACES_COUNT = void 0;
var _constants = require("../risk_score/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_ENGINE_URL = exports.RISK_ENGINE_URL = `${_constants.INTERNAL_RISK_SCORE_URL}/engine`;
const RISK_ENGINE_STATUS_URL = exports.RISK_ENGINE_STATUS_URL = `${RISK_ENGINE_URL}/status`;
const RISK_ENGINE_INIT_URL = exports.RISK_ENGINE_INIT_URL = `${RISK_ENGINE_URL}/init`;
const RISK_ENGINE_ENABLE_URL = exports.RISK_ENGINE_ENABLE_URL = `${RISK_ENGINE_URL}/enable`;
const RISK_ENGINE_DISABLE_URL = exports.RISK_ENGINE_DISABLE_URL = `${RISK_ENGINE_URL}/disable`;
const RISK_ENGINE_PRIVILEGES_URL = exports.RISK_ENGINE_PRIVILEGES_URL = `${RISK_ENGINE_URL}/privileges`;
const RISK_ENGINE_SETTINGS_URL = exports.RISK_ENGINE_SETTINGS_URL = `${RISK_ENGINE_URL}/settings`;
const MAX_SPACES_COUNT = exports.MAX_SPACES_COUNT = 1;
const RISK_ENGINE_REQUIRED_ES_CLUSTER_PRIVILEGES = exports.RISK_ENGINE_REQUIRED_ES_CLUSTER_PRIVILEGES = ['manage_index_templates', 'manage_transform'];
const RISK_SCORE_INDEX_PATTERN = exports.RISK_SCORE_INDEX_PATTERN = 'risk-score.risk-score-*';
const RISK_ENGINE_REQUIRED_ES_INDEX_PRIVILEGES = exports.RISK_ENGINE_REQUIRED_ES_INDEX_PRIVILEGES = Object.freeze({
  [RISK_SCORE_INDEX_PATTERN]: ['read', 'write']
});