"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneDataGenerator = void 0;
var _lodash = require("lodash");
var _endpoint_action_generator = require("./endpoint_action_generator");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SentinelOneDataGenerator extends _endpoint_action_generator.EndpointActionGenerator {
  generate(overrides = {}) {
    return super.generate({
      EndpointActions: {
        input_type: 'sentinel_one'
      },
      ...overrides
    });
  }

  /** Generate a SentinelOne activity index ES doc */
  generateActivityEsDoc(overrides = {}) {
    const doc = {
      sentinel_one: {
        activity: {
          agent: {
            id: this.seededUUIDv4()
          },
          updated_at: '2024-03-29T13:45:21.723Z',
          description: {
            primary: 'Some description here'
          },
          id: this.seededUUIDv4(),
          type: 1001
        }
      }
    };
    return (0, _lodash.merge)(doc, overrides);
  }
  generateActivityEsSearchHit(overrides = {}) {
    const hit = this.toEsSearchHit(this.generateActivityEsDoc(overrides), _.SENTINEL_ONE_ACTIVITY_INDEX_PATTERN);
    hit.inner_hits = {
      first_found: {
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        hits: {
          hits: [this.toEsSearchHit(hit._source, hit._index)]
        }
      }
    };
    return hit;
  }
  generateActivityEsSearchResponse(docs = [this.generateActivityEsSearchHit()]) {
    return this.toEsSearchResponse(docs);
  }
}
exports.SentinelOneDataGenerator = SentinelOneDataGenerator;