"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventFiltersGenerator = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _exceptions_list_item_generator = require("./exceptions_list_item_generator");
var _artifacts = require("../service/artifacts");
var _base_data_generator = require("./base_data_generator");
var _alerts_ecs_fields = require("./common/alerts_ecs_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTRY_OPERATORS = ['included', 'excluded'];
class EventFiltersGenerator extends _base_data_generator.BaseDataGenerator {
  generate(overrides = {}) {
    return {
      id: this.seededUUIDv4(),
      item_id: this.seededUUIDv4(),
      list_id: _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.eventFilters.id,
      meta: undefined,
      name: `Event filter (${this.randomString(5)})`,
      description: `created by ${this.constructor.name}`,
      tags: [_artifacts.GLOBAL_ARTIFACT_TAG],
      entries: this.randomEventFilterEntries(),
      expire_time: undefined,
      namespace_type: 'agnostic',
      type: 'simple',
      os_types: [this.randomOSFamily()],
      tie_breaker_id: this.seededUUIDv4(),
      _version: this.randomString(5),
      comments: [],
      created_at: this.randomPastDate(),
      created_by: this.randomUser(),
      updated_at: '2020-04-20T15:25:31.830Z',
      updated_by: this.randomUser(),
      ...overrides
    };
  }
  generateEventFilterForCreate(overrides = {}) {
    return {
      ...(0, _exceptions_list_item_generator.exceptionItemToCreateExceptionItem)(this.generate()),
      ...overrides
    };
  }
  randomEventFilterEntries(count = this.randomN(5)) {
    return Array.from({
      length: count || 1
    }, () => {
      if (this.randomBoolean()) {
        // single entry
        return {
          field: this.randomChoice(_alerts_ecs_fields.ENDPOINT_EVENTS_LOG_INDEX_FIELDS),
          operator: this.randomChoice(ENTRY_OPERATORS),
          type: 'match',
          value: this.randomString(10)
        };
      } else {
        // nested entry
        return {
          field: this.randomChoice(_alerts_ecs_fields.ENDPOINT_EVENTS_LOG_INDEX_FIELDS),
          type: 'nested',
          entries: [{
            field: this.randomChoice(_alerts_ecs_fields.ENDPOINT_EVENTS_LOG_INDEX_FIELDS),
            operator: this.randomChoice(ENTRY_OPERATORS),
            type: 'match',
            value: this.randomString(10)
          }]
        };
      }
    });
  }
}
exports.EventFiltersGenerator = EventFiltersGenerator;