"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortTimeline = exports.sortFieldTimeline = exports.responseFavoriteTimeline = exports.pageInfoTimeline = exports.importTimelineResultSchema = exports.getTimelinesArgs = exports.direction = exports.allTimelinesResponse = exports.TimelineTypeLiteralWithNullRt = exports.TimelineTypeLiteralRt = exports.TimelineType = exports.TimelineStatusLiteralRt = exports.TimelineStatus = exports.TimelineSavedToReturnObjectRuntimeType = exports.TimelineResponseType = exports.TimelineErrorResponseType = exports.TemplateTimelineTypeLiteralWithNullRt = exports.TemplateTimelineTypeLiteralRt = exports.TemplateTimelineType = exports.SortFieldTimeline = exports.SingleTimelineResponseType = exports.SavedTimelineRuntimeType = exports.RowRendererId = exports.RowRendererCount = exports.ResolvedTimelineSavedObjectToReturnObjectRuntimeType = exports.ResolvedSingleTimelineResponseType = exports.NoteRuntimeType = exports.DataProviderTypeLiteralRt = exports.DataProviderType = exports.BareNoteSchema = void 0;
var runtimeTypes = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _utility_types = require("../../../utility_types");
var _search_strategy = require("../../../search_strategy");
var _pinned_events_route = require("../pinned_events/pinned_events_route");
var _rule_schema_legacy = require("../../detection_engine/model/rule_schema_legacy");
var _error_schema = require("./error_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO https://github.com/elastic/security-team/issues/7491
// eslint-disable-next-line no-restricted-imports

const BareNoteSchema = exports.BareNoteSchema = runtimeTypes.intersection([runtimeTypes.type({
  timelineId: runtimeTypes.string
}), runtimeTypes.partial({
  eventId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  note: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  created: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  createdBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  updated: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  updatedBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
})]);

/**
 * This type represents a note type stored in a saved object that does not include any fields that reference
 * other saved objects.
 */

const NoteRuntimeType = exports.NoteRuntimeType = runtimeTypes.intersection([BareNoteSchema, runtimeTypes.type({
  noteId: runtimeTypes.string,
  version: runtimeTypes.string
})]);
/*
 *  ColumnHeader Types
 */
const SavedColumnHeaderRuntimeType = runtimeTypes.partial({
  aggregatable: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  category: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  columnHeaderType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  description: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  example: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  indexes: (0, _utility_types.unionWithNullType)(runtimeTypes.array(runtimeTypes.string)),
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  placeholder: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  searchable: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  type: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  DataProvider Types
 */
const SavedDataProviderQueryMatchBasicRuntimeType = runtimeTypes.partial({
  field: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  displayField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  value: runtimeTypes.union([runtimeTypes.null, runtimeTypes.string, runtimeTypes.array(runtimeTypes.string)]),
  displayValue: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  operator: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedDataProviderQueryMatchRuntimeType = runtimeTypes.partial({
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  enabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  excluded: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  kqlQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  queryMatch: (0, _utility_types.unionWithNullType)(SavedDataProviderQueryMatchBasicRuntimeType)
});
let DataProviderType = exports.DataProviderType = /*#__PURE__*/function (DataProviderType) {
  DataProviderType["default"] = "default";
  DataProviderType["template"] = "template";
  return DataProviderType;
}({});
const DataProviderTypeLiteralRt = exports.DataProviderTypeLiteralRt = runtimeTypes.union([runtimeTypes.literal(DataProviderType.default), runtimeTypes.literal(DataProviderType.template)]);
const SavedDataProviderRuntimeType = runtimeTypes.partial({
  id: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  name: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  enabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  excluded: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  kqlQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  queryMatch: (0, _utility_types.unionWithNullType)(SavedDataProviderQueryMatchBasicRuntimeType),
  and: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedDataProviderQueryMatchRuntimeType)),
  type: (0, _utility_types.unionWithNullType)(DataProviderTypeLiteralRt)
});

/*
 *  Filters Types
 */
const SavedFilterMetaRuntimeType = runtimeTypes.partial({
  alias: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  controlledBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  disabled: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  field: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  formattedValue: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  index: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  key: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  negate: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  params: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  type: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  value: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedFilterRuntimeType = runtimeTypes.partial({
  exists: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  meta: (0, _utility_types.unionWithNullType)(SavedFilterMetaRuntimeType),
  match_all: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  missing: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  query: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  range: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  script: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  eqlOptionsQuery -> filterQuery Types
 */
const EqlOptionsRuntimeType = runtimeTypes.partial({
  eventCategoryField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  query: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  tiebreakerField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  timestampField: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  size: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number]))
});

/*
 *  kqlQuery -> filterQuery Types
 */
const SavedKueryFilterQueryRuntimeType = runtimeTypes.partial({
  kind: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  expression: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedSerializedFilterQueryQueryRuntimeType = runtimeTypes.partial({
  kuery: (0, _utility_types.unionWithNullType)(SavedKueryFilterQueryRuntimeType),
  serializedQuery: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedFilterQueryQueryRuntimeType = runtimeTypes.partial({
  filterQuery: (0, _utility_types.unionWithNullType)(SavedSerializedFilterQueryQueryRuntimeType)
});

/*
 *  DatePicker Range Types
 */
const SavedDateRangePickerRuntimeType = runtimeTypes.partial({
  /* Before the change of all timestamp to ISO string the values of start and from
   * attributes where a number. Specifically UNIX timestamps.
   * To support old timeline's saved object we need to add the number io-ts type
   */
  start: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number])),
  end: (0, _utility_types.unionWithNullType)(runtimeTypes.union([runtimeTypes.string, runtimeTypes.number]))
});

/*
 *  Favorite Types
 */
const SavedFavoriteRuntimeType = runtimeTypes.partial({
  keySearch: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  favoriteDate: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  fullName: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  userName: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/*
 *  Sort Types
 */

const SavedSortObject = runtimeTypes.partial({
  columnId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  columnType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  sortDirection: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});
const SavedSortRuntimeType = runtimeTypes.union([runtimeTypes.array(SavedSortObject), SavedSortObject]);
/*
 *  Timeline Statuses
 */
let TimelineStatus = exports.TimelineStatus = /*#__PURE__*/function (TimelineStatus) {
  TimelineStatus["active"] = "active";
  TimelineStatus["draft"] = "draft";
  TimelineStatus["immutable"] = "immutable";
  return TimelineStatus;
}({});
const TimelineStatusLiteralRt = exports.TimelineStatusLiteralRt = runtimeTypes.union([runtimeTypes.literal(TimelineStatus.active), runtimeTypes.literal(TimelineStatus.draft), runtimeTypes.literal(TimelineStatus.immutable)]);
const TimelineStatusLiteralWithNullRt = (0, _utility_types.unionWithNullType)(TimelineStatusLiteralRt);
let RowRendererId = exports.RowRendererId = /*#__PURE__*/function (RowRendererId) {
  RowRendererId["alert"] = "alert";
  RowRendererId["alerts"] = "alerts";
  RowRendererId["auditd"] = "auditd";
  RowRendererId["auditd_file"] = "auditd_file";
  RowRendererId["library"] = "library";
  RowRendererId["netflow"] = "netflow";
  RowRendererId["plain"] = "plain";
  RowRendererId["registry"] = "registry";
  RowRendererId["suricata"] = "suricata";
  RowRendererId["system"] = "system";
  RowRendererId["system_dns"] = "system_dns";
  RowRendererId["system_endgame_process"] = "system_endgame_process";
  RowRendererId["system_file"] = "system_file";
  RowRendererId["system_fim"] = "system_fim";
  RowRendererId["system_security_event"] = "system_security_event";
  RowRendererId["system_socket"] = "system_socket";
  RowRendererId["threat_match"] = "threat_match";
  RowRendererId["zeek"] = "zeek";
  return RowRendererId;
}({});
const RowRendererCount = exports.RowRendererCount = Object.keys(RowRendererId).length;
const RowRendererIdRuntimeType = (0, _utility_types.stringEnum)(RowRendererId, 'RowRendererId');

/**
 * Timeline template type
 */
let TemplateTimelineType = exports.TemplateTimelineType = /*#__PURE__*/function (TemplateTimelineType) {
  TemplateTimelineType["elastic"] = "elastic";
  TemplateTimelineType["custom"] = "custom";
  return TemplateTimelineType;
}({});
const TemplateTimelineTypeLiteralRt = exports.TemplateTimelineTypeLiteralRt = runtimeTypes.union([runtimeTypes.literal(TemplateTimelineType.elastic), runtimeTypes.literal(TemplateTimelineType.custom)]);
const TemplateTimelineTypeLiteralWithNullRt = exports.TemplateTimelineTypeLiteralWithNullRt = (0, _utility_types.unionWithNullType)(TemplateTimelineTypeLiteralRt);
/*
 *  Timeline Types
 */
let TimelineType = exports.TimelineType = /*#__PURE__*/function (TimelineType) {
  TimelineType["default"] = "default";
  TimelineType["template"] = "template";
  return TimelineType;
}({});
const TimelineTypeLiteralRt = exports.TimelineTypeLiteralRt = runtimeTypes.union([runtimeTypes.literal(TimelineType.template), runtimeTypes.literal(TimelineType.default)]);
const TimelineTypeLiteralWithNullRt = exports.TimelineTypeLiteralWithNullRt = (0, _utility_types.unionWithNullType)(TimelineTypeLiteralRt);
/**
 * This is the response type
 */
const SavedTimelineRuntimeType = exports.SavedTimelineRuntimeType = runtimeTypes.partial({
  columns: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedColumnHeaderRuntimeType)),
  dataProviders: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedDataProviderRuntimeType)),
  dataViewId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  description: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  eqlOptions: (0, _utility_types.unionWithNullType)(EqlOptionsRuntimeType),
  eventType: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  excludedRowRendererIds: (0, _utility_types.unionWithNullType)(runtimeTypes.array(RowRendererIdRuntimeType)),
  favorite: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedFavoriteRuntimeType)),
  filters: (0, _utility_types.unionWithNullType)(runtimeTypes.array(SavedFilterRuntimeType)),
  indexNames: (0, _utility_types.unionWithNullType)(runtimeTypes.array(runtimeTypes.string)),
  kqlMode: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  kqlQuery: (0, _utility_types.unionWithNullType)(SavedFilterQueryQueryRuntimeType),
  title: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineVersion: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  timelineType: (0, _utility_types.unionWithNullType)(TimelineTypeLiteralRt),
  dateRange: (0, _utility_types.unionWithNullType)(SavedDateRangePickerRuntimeType),
  savedQueryId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  sort: (0, _utility_types.unionWithNullType)(SavedSortRuntimeType),
  status: (0, _utility_types.unionWithNullType)(TimelineStatusLiteralRt),
  created: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  createdBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  updated: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  updatedBy: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  savedSearchId: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
});

/**
 * This type represents a timeline type stored in a saved object that does not include any fields that reference
 * other saved objects.
 */

const TimelineSavedToReturnObjectRuntimeType = exports.TimelineSavedToReturnObjectRuntimeType = runtimeTypes.intersection([SavedTimelineRuntimeType, runtimeTypes.type({
  savedObjectId: runtimeTypes.string,
  version: runtimeTypes.string
}), runtimeTypes.partial({
  eventIdToNoteIds: runtimeTypes.array(NoteRuntimeType),
  noteIds: runtimeTypes.array(runtimeTypes.string),
  notes: runtimeTypes.array(NoteRuntimeType),
  pinnedEventIds: runtimeTypes.array(runtimeTypes.string),
  pinnedEventsSaveObject: runtimeTypes.array(_pinned_events_route.PinnedEventRuntimeType)
})]);
const SingleTimelineResponseType = exports.SingleTimelineResponseType = runtimeTypes.type({
  data: runtimeTypes.type({
    getOneTimeline: TimelineSavedToReturnObjectRuntimeType
  })
});
/** Resolved Timeline Response */
const ResolvedTimelineSavedObjectToReturnObjectRuntimeType = exports.ResolvedTimelineSavedObjectToReturnObjectRuntimeType = runtimeTypes.intersection([runtimeTypes.type({
  timeline: TimelineSavedToReturnObjectRuntimeType,
  outcome: _rule_schema_legacy.SavedObjectResolveOutcome
}), runtimeTypes.partial({
  alias_target_id: _rule_schema_legacy.SavedObjectResolveAliasTargetId,
  alias_purpose: _rule_schema_legacy.SavedObjectResolveAliasPurpose
})]);
const ResolvedSingleTimelineResponseType = exports.ResolvedSingleTimelineResponseType = runtimeTypes.type({
  data: ResolvedTimelineSavedObjectToReturnObjectRuntimeType
});
const responseTimelines = runtimeTypes.type({
  timeline: runtimeTypes.array(TimelineSavedToReturnObjectRuntimeType),
  totalCount: runtimeTypes.number
});
const allTimelinesResponse = exports.allTimelinesResponse = runtimeTypes.intersection([responseTimelines, runtimeTypes.type({
  defaultTimelineCount: runtimeTypes.number,
  templateTimelineCount: runtimeTypes.number,
  elasticTemplateTimelineCount: runtimeTypes.number,
  customTemplateTimelineCount: runtimeTypes.number,
  favoriteCount: runtimeTypes.number
})]);
/**
 * All Timeline Saved object type with metadata
 */
const TimelineResponseType = exports.TimelineResponseType = runtimeTypes.type({
  data: runtimeTypes.type({
    persistTimeline: runtimeTypes.intersection([runtimeTypes.partial({
      code: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
      message: (0, _utility_types.unionWithNullType)(runtimeTypes.string)
    }), runtimeTypes.type({
      timeline: TimelineSavedToReturnObjectRuntimeType
    })])
  })
});
const TimelineErrorResponseType = exports.TimelineErrorResponseType = runtimeTypes.union([runtimeTypes.type({
  status_code: runtimeTypes.number,
  message: runtimeTypes.string
}), runtimeTypes.type({
  statusCode: runtimeTypes.number,
  message: runtimeTypes.string
})]);
let SortFieldTimeline = exports.SortFieldTimeline = /*#__PURE__*/function (SortFieldTimeline) {
  SortFieldTimeline["title"] = "title";
  SortFieldTimeline["description"] = "description";
  SortFieldTimeline["updated"] = "updated";
  SortFieldTimeline["created"] = "created";
  return SortFieldTimeline;
}({});
const sortFieldTimeline = exports.sortFieldTimeline = runtimeTypes.union([runtimeTypes.literal(SortFieldTimeline.title), runtimeTypes.literal(SortFieldTimeline.description), runtimeTypes.literal(SortFieldTimeline.updated), runtimeTypes.literal(SortFieldTimeline.created)]);
const direction = exports.direction = runtimeTypes.union([runtimeTypes.literal(_search_strategy.Direction.asc), runtimeTypes.literal(_search_strategy.Direction.desc)]);
const sortTimeline = exports.sortTimeline = runtimeTypes.type({
  sortField: sortFieldTimeline,
  sortOrder: direction
});

/**
 * Import/export timelines
 */

const importTimelineResultSchema = exports.importTimelineResultSchema = runtimeTypes.exact(runtimeTypes.type({
  success: runtimeTypes.boolean,
  success_count: _securitysolutionIoTsTypes.PositiveInteger,
  timelines_installed: _securitysolutionIoTsTypes.PositiveInteger,
  timelines_updated: _securitysolutionIoTsTypes.PositiveInteger,
  errors: runtimeTypes.array(_error_schema.ErrorSchema)
}));
const favoriteTimelineResult = runtimeTypes.partial({
  fullName: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  userName: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  favoriteDate: (0, _utility_types.unionWithNullType)(runtimeTypes.number)
});
const responseFavoriteTimeline = exports.responseFavoriteTimeline = runtimeTypes.partial({
  savedObjectId: runtimeTypes.string,
  version: runtimeTypes.string,
  code: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  message: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineId: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  templateTimelineVersion: (0, _utility_types.unionWithNullType)(runtimeTypes.number),
  timelineType: (0, _utility_types.unionWithNullType)(TimelineTypeLiteralRt),
  favorite: (0, _utility_types.unionWithNullType)(runtimeTypes.array(favoriteTimelineResult))
});
const pageInfoTimeline = exports.pageInfoTimeline = runtimeTypes.type({
  pageIndex: runtimeTypes.number,
  pageSize: runtimeTypes.number
});
const getTimelinesArgs = exports.getTimelinesArgs = runtimeTypes.partial({
  onlyUserFavorite: (0, _utility_types.unionWithNullType)(runtimeTypes.boolean),
  pageInfo: (0, _utility_types.unionWithNullType)(pageInfoTimeline),
  search: (0, _utility_types.unionWithNullType)(runtimeTypes.string),
  sort: (0, _utility_types.unionWithNullType)(sortTimeline),
  status: (0, _utility_types.unionWithNullType)(TimelineStatusLiteralRt),
  timelineType: (0, _utility_types.unionWithNullType)(TimelineTypeLiteralRt)
});