"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestBasicOptionsSchema = void 0;
var _zod = require("zod");
var _filter_query = require("./filter_query");
var _timerange = require("./timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requestBasicOptionsSchema = exports.requestBasicOptionsSchema = _zod.z.object({
  timerange: _timerange.timerange.optional(),
  filterQuery: _filter_query.filterQuery,
  defaultIndex: _zod.z.array(_zod.z.string()).optional(),
  id: _zod.z.string().optional(),
  params: _zod.z.any().optional()
});