"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreWeights = exports.RiskScoreWeight = exports.RiskScoreInput = exports.RiskScore = exports.RiskEngineInitStep = exports.PageSize = exports.KibanaDate = exports.IdentifierTypeEnum = exports.IdentifierType = exports.Filter = exports.EntityAnalyticsPrivileges = exports.DateRange = exports.DataViewId = exports.AfterKeys = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Entity Analytics Common Schema
 *   version: 1.0.0
 */

const EntityAnalyticsPrivileges = exports.EntityAnalyticsPrivileges = _zod.z.object({
  has_all_required: _zod.z.boolean(),
  has_read_permissions: _zod.z.boolean().optional(),
  has_write_permissions: _zod.z.boolean().optional(),
  privileges: _zod.z.object({
    elasticsearch: _zod.z.object({
      cluster: _zod.z.object({
        manage_index_templates: _zod.z.boolean().optional(),
        manage_transform: _zod.z.boolean().optional()
      }).optional(),
      index: _zod.z.object({}).catchall(_zod.z.object({
        read: _zod.z.boolean().optional(),
        write: _zod.z.boolean().optional()
      })).optional()
    })
  })
});
const AfterKeys = exports.AfterKeys = _zod.z.object({
  host: _zod.z.object({}).catchall(_zod.z.string()).optional(),
  user: _zod.z.object({}).catchall(_zod.z.string()).optional()
});

/**
 * The identifier of the Kibana data view to be used when generating risk scores.
 */

const DataViewId = exports.DataViewId = _zod.z.string();

/**
 * An elasticsearch DSL filter object. Used to filter the risk inputs involved, which implicitly filters the risk scores themselves.
 */

const Filter = exports.Filter = _zod.z.object({});

/**
 * Specifies how many scores will be involved in a given calculation. Note that this value is per `identifier_type`, i.e. a value of 10 will calculate 10 host scores and 10 user scores, if available. To avoid missed data, keep this value consistent while paginating through scores.
 */

const PageSize = exports.PageSize = _zod.z.number().default(1000);
const KibanaDate = exports.KibanaDate = _zod.z.string();

/**
 * Defines the time period on which risk inputs will be filtered.
 */

const DateRange = exports.DateRange = _zod.z.object({
  start: KibanaDate,
  end: KibanaDate
});
const IdentifierType = exports.IdentifierType = _zod.z.enum(['host', 'user']);
const IdentifierTypeEnum = exports.IdentifierTypeEnum = IdentifierType.enum;

/**
 * A generic representation of a document contributing to a Risk Score.
 */

const RiskScoreInput = exports.RiskScoreInput = _zod.z.object({
  /**
   * The unique identifier (`_id`) of the original source document
   */
  id: _zod.z.string().optional(),
  /**
   * The unique index (`_index`) of the original source document
   */
  index: _zod.z.string().optional(),
  /**
   * The risk category of the risk input document.
   */
  category: _zod.z.string().optional(),
  /**
   * A human-readable description of the risk input document.
   */
  description: _zod.z.string().optional(),
  /**
   * The weighted risk score of the risk input document.
   */
  risk_score: _zod.z.number().min(0).max(100).optional(),
  /**
   * The @timestamp of the risk input document.
   */
  timestamp: _zod.z.string().optional()
});
const RiskScore = exports.RiskScore = _zod.z.object({
  /**
   * The time at which the risk score was calculated.
   */
  '@timestamp': _zod.z.string().datetime(),
  /**
   * The identifier field defining this risk score. Coupled with `id_value`, uniquely identifies the entity being scored.
   */
  id_field: _zod.z.string(),
  /**
   * The identifier value defining this risk score. Coupled with `id_field`, uniquely identifies the entity being scored.
   */
  id_value: _zod.z.string(),
  /**
   * Lexical description of the entity's risk.
   */
  calculated_level: _zod.z.string(),
  /**
   * The raw numeric value of the given entity's risk score.
   */
  calculated_score: _zod.z.number(),
  /**
   * The normalized numeric value of the given entity's risk score. Useful for comparing with other entities.
   */
  calculated_score_norm: _zod.z.number().min(0).max(100),
  /**
   * The contribution of Category 1 to the overall risk score (`calculated_score`). Category 1 contains Detection Engine Alerts.
   */
  category_1_score: _zod.z.number(),
  /**
   * The number of risk input documents that contributed to the Category 1 score (`category_1_score`).
   */
  category_1_count: _zod.z.number(),
  /**
   * A list of the highest-risk documents contributing to this risk score. Useful for investigative purposes.
   */
  inputs: _zod.z.array(RiskScoreInput)
});

/**
 * Configuration used to tune risk scoring. Weights can be used to change the score contribution of risk inputs for hosts and users at both a global level and also for Risk Input categories (e.g. 'category_1').
 */

const RiskScoreWeight = exports.RiskScoreWeight = _zod.z.object({
  type: _zod.z.string(),
  value: _zod.z.string().optional(),
  host: _zod.z.number().min(0).max(1).optional(),
  user: _zod.z.number().min(0).max(1).optional()
});

/**
 * A list of weights to be applied to the scoring calculation.
 */

const RiskScoreWeights = exports.RiskScoreWeights = _zod.z.array(RiskScoreWeight);
const RiskEngineInitStep = exports.RiskEngineInitStep = _zod.z.object({
  type: _zod.z.string(),
  success: _zod.z.boolean(),
  error: _zod.z.string().optional()
});