"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetRuleExecutionResultsResponse = exports.GetRuleExecutionResultsRequestQuery = exports.GetRuleExecutionResultsRequestParams = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _execution_status = require("../../model/execution_status.gen");
var _execution_result = require("../../model/execution_result.gen");
var _sorting = require("../../../model/sorting.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Get Rule Execution Results API endpoint
 *   version: 1
 */

const GetRuleExecutionResultsRequestQuery = exports.GetRuleExecutionResultsRequestQuery = _zod.z.object({
  /**
   * Start date of the time range to query
   */
  start: _zod.z.string().datetime(),
  /**
   * End date of the time range to query
   */
  end: _zod.z.string().datetime(),
  /**
   * Query text to filter results by
   */
  query_text: _zod.z.string().optional().default(''),
  /**
   * Comma-separated list of rule execution statuses to filter results by
   */
  status_filters: (0, _zodHelpers.ArrayFromString)(_execution_status.RuleExecutionStatus).optional().default([]),
  /**
   * Field to sort results by
   */
  sort_field: _execution_result.SortFieldOfRuleExecutionResult.optional().default('timestamp'),
  /**
   * Sort order to sort results by
   */
  sort_order: _sorting.SortOrder.optional().default('desc'),
  /**
   * Page number to return
   */
  page: _zod.z.coerce.number().int().optional().default(1),
  /**
   * Number of results per page
   */
  per_page: _zod.z.coerce.number().int().optional().default(20)
});
const GetRuleExecutionResultsRequestParams = exports.GetRuleExecutionResultsRequestParams = _zod.z.object({
  /**
   * Saved object ID of the rule to get execution results for
   */
  ruleId: _zod.z.string().min(1)
});
const GetRuleExecutionResultsResponse = exports.GetRuleExecutionResultsResponse = _zod.z.object({
  events: _zod.z.array(_execution_result.RuleExecutionResult).optional(),
  total: _zod.z.number().int().optional()
});