"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottleForBulkActionsEnum = exports.ThrottleForBulkActions = exports.RuleDetailsInError = exports.PerformBulkActionResponse = exports.PerformBulkActionRequestQuery = exports.PerformBulkActionRequestBody = exports.NormalizedRuleError = exports.NormalizedRuleAction = exports.BulkExportRules = exports.BulkExportActionResponse = exports.BulkEnableRules = exports.BulkEditSkipReason = exports.BulkEditRules = exports.BulkEditActionSummary = exports.BulkEditActionResults = exports.BulkEditActionResponse = exports.BulkDuplicateRules = exports.BulkDisableRules = exports.BulkDeleteRules = exports.BulkActionsDryRunErrCodeEnum = exports.BulkActionsDryRunErrCode = exports.BulkActionTypeEnum = exports.BulkActionType = exports.BulkActionSkipResult = exports.BulkActionEditTypeEnum = exports.BulkActionEditType = exports.BulkActionEditPayloadTimeline = exports.BulkActionEditPayloadTags = exports.BulkActionEditPayloadSchedule = exports.BulkActionEditPayloadRuleActions = exports.BulkActionEditPayloadIndexPatterns = exports.BulkActionEditPayload = exports.BulkActionBase = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_schemas = require("../../model/rule_schema/rule_schemas.gen");
var _common_attributes = require("../../model/rule_schema/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Actions API endpoint
 *   version: 2023-10-31
 */

const BulkEditSkipReason = exports.BulkEditSkipReason = _zod.z.literal('RULE_NOT_MODIFIED');
const BulkActionSkipResult = exports.BulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: BulkEditSkipReason
});
const RuleDetailsInError = exports.RuleDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
const BulkActionsDryRunErrCode = exports.BulkActionsDryRunErrCode = _zod.z.enum(['IMMUTABLE', 'MACHINE_LEARNING_AUTH', 'MACHINE_LEARNING_INDEX_PATTERN', 'ESQL_INDEX_PATTERN']);
const BulkActionsDryRunErrCodeEnum = exports.BulkActionsDryRunErrCodeEnum = BulkActionsDryRunErrCode.enum;
const NormalizedRuleError = exports.NormalizedRuleError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: BulkActionsDryRunErrCode.optional(),
  rules: _zod.z.array(RuleDetailsInError)
});
const BulkEditActionResults = exports.BulkEditActionResults = _zod.z.object({
  updated: _zod.z.array(_rule_schemas.RuleResponse),
  created: _zod.z.array(_rule_schemas.RuleResponse),
  deleted: _zod.z.array(_rule_schemas.RuleResponse),
  skipped: _zod.z.array(BulkActionSkipResult)
});
const BulkEditActionSummary = exports.BulkEditActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const BulkEditActionResponse = exports.BulkEditActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  rules_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: BulkEditActionResults,
    summary: BulkEditActionSummary,
    errors: _zod.z.array(NormalizedRuleError).optional()
  })
});
const BulkExportActionResponse = exports.BulkExportActionResponse = _zod.z.string();
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter rules
   */
  query: _zod.z.string().optional(),
  /**
   * Array of rule IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const BulkDeleteRules = exports.BulkDeleteRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('delete')
}));
const BulkDisableRules = exports.BulkDisableRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('disable')
}));
const BulkEnableRules = exports.BulkEnableRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('enable')
}));
const BulkExportRules = exports.BulkExportRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('export')
}));
const BulkDuplicateRules = exports.BulkDuplicateRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('duplicate'),
  duplicate: _zod.z.object({
    /**
     * Whether to copy exceptions from the original rule
     */
    include_exceptions: _zod.z.boolean(),
    /**
     * Whether to copy expired exceptions from the original rule
     */
    include_expired_exceptions: _zod.z.boolean()
  }).optional()
}));

/**
 * The condition for throttling the notification: 'rule', 'no_actions', or time duration
 */

const ThrottleForBulkActions = exports.ThrottleForBulkActions = _zod.z.enum(['rule', '1h', '1d', '7d']);
const ThrottleForBulkActionsEnum = exports.ThrottleForBulkActionsEnum = ThrottleForBulkActions.enum;
const BulkActionType = exports.BulkActionType = _zod.z.enum(['enable', 'disable', 'export', 'delete', 'duplicate', 'edit']);
const BulkActionTypeEnum = exports.BulkActionTypeEnum = BulkActionType.enum;
const BulkActionEditType = exports.BulkActionEditType = _zod.z.enum(['add_tags', 'delete_tags', 'set_tags', 'add_index_patterns', 'delete_index_patterns', 'set_index_patterns', 'set_timeline', 'add_rule_actions', 'set_rule_actions', 'set_schedule']);
const BulkActionEditTypeEnum = exports.BulkActionEditTypeEnum = BulkActionEditType.enum;
const NormalizedRuleAction = exports.NormalizedRuleAction = _zod.z.object({
  group: _common_attributes.RuleActionGroup,
  id: _common_attributes.RuleActionId,
  params: _common_attributes.RuleActionParams,
  frequency: _common_attributes.RuleActionFrequency.optional(),
  alerts_filter: _common_attributes.RuleActionAlertsFilter.optional()
}).strict();
const BulkActionEditPayloadRuleActions = exports.BulkActionEditPayloadRuleActions = _zod.z.object({
  type: _zod.z.enum(['add_rule_actions', 'set_rule_actions']),
  value: _zod.z.object({
    throttle: ThrottleForBulkActions.optional(),
    actions: _zod.z.array(NormalizedRuleAction)
  })
});
const BulkActionEditPayloadSchedule = exports.BulkActionEditPayloadSchedule = _zod.z.object({
  type: _zod.z.literal('set_schedule'),
  value: _zod.z.object({
    /**
     * Interval in which the rule is executed
     */
    interval: _zod.z.string().regex(/^[1-9]\d*[smh]$/),
    /**
     * Lookback time for the rule
     */
    lookback: _zod.z.string().regex(/^[1-9]\d*[smh]$/)
  })
});
const BulkActionEditPayloadIndexPatterns = exports.BulkActionEditPayloadIndexPatterns = _zod.z.object({
  type: _zod.z.enum(['add_index_patterns', 'delete_index_patterns', 'set_index_patterns']),
  value: _common_attributes.IndexPatternArray,
  overwrite_data_views: _zod.z.boolean().optional()
});
const BulkActionEditPayloadTags = exports.BulkActionEditPayloadTags = _zod.z.object({
  type: _zod.z.enum(['add_tags', 'delete_tags', 'set_tags']),
  value: _common_attributes.RuleTagArray
});
const BulkActionEditPayloadTimeline = exports.BulkActionEditPayloadTimeline = _zod.z.object({
  type: _zod.z.literal('set_timeline'),
  value: _zod.z.object({
    timeline_id: _common_attributes.TimelineTemplateId,
    timeline_title: _common_attributes.TimelineTemplateTitle
  })
});
const BulkActionEditPayload = exports.BulkActionEditPayload = _zod.z.union([BulkActionEditPayloadTags, BulkActionEditPayloadIndexPatterns, BulkActionEditPayloadTimeline, BulkActionEditPayloadRuleActions, BulkActionEditPayloadSchedule]);
const BulkEditRules = exports.BulkEditRules = BulkActionBase.merge(_zod.z.object({
  action: _zod.z.literal('edit'),
  /**
   * Array of objects containing the edit operations
   */
  edit: _zod.z.array(BulkActionEditPayload).min(1)
}));
const PerformBulkActionRequestQuery = exports.PerformBulkActionRequestQuery = _zod.z.object({
  /**
   * Enables dry run mode for the request call.
   */
  dry_run: _zodHelpers.BooleanFromString.optional()
});
const PerformBulkActionRequestBody = exports.PerformBulkActionRequestBody = _zod.z.union([BulkDeleteRules, BulkDisableRules, BulkEnableRules, BulkExportRules, BulkDuplicateRules, BulkEditRules]);
const PerformBulkActionResponse = exports.PerformBulkActionResponse = _zod.z.union([BulkEditActionResponse, BulkExportActionResponse]);