"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rulesReferencedByExceptionListsSchema = exports.rulesReferencedByExceptionListSchema = exports.ruleReferenceRuleInfoSchema = exports.findExceptionReferencesOnRuleSchema = exports.exceptionListRuleReferencesSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _rule_schema_legacy = require("../../model/rule_schema_legacy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO https://github.com/elastic/security-team/issues/7491
// eslint-disable-next-line no-restricted-imports

// If ids and list_ids are undefined, route will fetch all lists matching the
// specified namespace type
const findExceptionReferencesOnRuleSchema = exports.findExceptionReferencesOnRuleSchema = t.intersection([t.exact(t.type({
  namespace_types: _securitysolutionIoTsListTypes.DefaultNamespaceArray
})), t.exact(t.partial({
  ids: _securitysolutionIoTsTypes.NonEmptyStringArray,
  list_ids: _securitysolutionIoTsTypes.NonEmptyStringArray
}))]);
const ruleReferenceRuleInfoSchema = exports.ruleReferenceRuleInfoSchema = t.exact(t.type({
  name: _rule_schema_legacy.RuleName,
  id: _rule_schema_legacy.RuleObjectId,
  rule_id: _rule_schema_legacy.RuleSignatureId,
  exception_lists: _securitysolutionIoTsListTypes.listArray
}));
const exceptionListRuleReferencesSchema = exports.exceptionListRuleReferencesSchema = t.intersection([_securitysolutionIoTsListTypes.exceptionListSchema, t.exact(t.type({
  referenced_rules: t.array(ruleReferenceRuleInfoSchema)
}))]);
const rulesReferencedByExceptionListSchema = exports.rulesReferencedByExceptionListSchema = t.record(_securitysolutionIoTsListTypes.list_id, exceptionListRuleReferencesSchema);
const rulesReferencedByExceptionListsSchema = exports.rulesReferencedByExceptionListsSchema = t.exact(t.type({
  references: t.array(rulesReferencedByExceptionListSchema)
}));