"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeSpecificRulesRequest = exports.UpgradeAllRulesRequest = exports.TPickVersionValues = exports.SkipRuleUpgradeReason = exports.RuleUpgradeSpecifier = exports.PickVersionValues = exports.PerformRuleUpgradeRequestBody = void 0;
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let PickVersionValues = exports.PickVersionValues = /*#__PURE__*/function (PickVersionValues) {
  PickVersionValues["BASE"] = "BASE";
  PickVersionValues["CURRENT"] = "CURRENT";
  PickVersionValues["TARGET"] = "TARGET";
  return PickVersionValues;
}({});
const TPickVersionValues = exports.TPickVersionValues = (0, _securitysolutionIoTsTypes.enumeration)('PickVersionValues', PickVersionValues);
const RuleUpgradeSpecifier = exports.RuleUpgradeSpecifier = t.exact(t.intersection([t.type({
  rule_id: t.string,
  /**
   * This parameter is needed for handling race conditions with Optimistic Concurrency Control.
   * Two or more users can call upgrade/_review and upgrade/_perform endpoints concurrently.
   * Also, in general the time between these two calls can be anything.
   * The idea is to only allow the user to install a rule if the user has reviewed the exact version
   * of it that had been returned from the _review endpoint. If the version changed on the BE,
   * upgrade/_perform endpoint will return a version mismatch error for this rule.
   */
  revision: t.number,
  /**
   * The target version to upgrade to.
   */
  version: t.number
}), t.partial({
  pick_version: TPickVersionValues
})]));
const UpgradeSpecificRulesRequest = exports.UpgradeSpecificRulesRequest = t.exact(t.intersection([t.type({
  mode: t.literal(`SPECIFIC_RULES`),
  rules: t.array(RuleUpgradeSpecifier)
}), t.partial({
  pick_version: TPickVersionValues
})]));
const UpgradeAllRulesRequest = exports.UpgradeAllRulesRequest = t.exact(t.intersection([t.type({
  mode: t.literal(`ALL_RULES`)
}), t.partial({
  pick_version: TPickVersionValues
})]));
const PerformRuleUpgradeRequestBody = exports.PerformRuleUpgradeRequestBody = t.union([UpgradeAllRulesRequest, UpgradeSpecificRulesRequest]);
let SkipRuleUpgradeReason = exports.SkipRuleUpgradeReason = /*#__PURE__*/function (SkipRuleUpgradeReason) {
  SkipRuleUpgradeReason["RULE_UP_TO_DATE"] = "RULE_UP_TO_DATE";
  return SkipRuleUpgradeReason;
}({});