"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreeWayMergeOutcome = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Type of result of an automatic three-way merge of three values:
 *   - base version
 *   - current version
 *   - target version
 */
let ThreeWayMergeOutcome = exports.ThreeWayMergeOutcome = /*#__PURE__*/function (ThreeWayMergeOutcome) {
  ThreeWayMergeOutcome["Current"] = "CURRENT";
  ThreeWayMergeOutcome["Target"] = "TARGET";
  ThreeWayMergeOutcome["Merged"] = "MERGED";
  ThreeWayMergeOutcome["Conflict"] = "CONFLICT";
  return ThreeWayMergeOutcome;
}({});