"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiffableThresholdFields = exports.DiffableThreatMatchFields = exports.DiffableSavedQueryFields = exports.DiffableRule = exports.DiffableNewTermsFields = exports.DiffableMachineLearningFields = exports.DiffableEsqlFields = exports.DiffableEqlFields = exports.DiffableCustomQueryFields = exports.DiffableCommonFields = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
var _rule_schema_legacy = require("../../../../model/rule_schema_legacy");
var _diffable_field_types = require("./diffable_field_types");
var _build_schema = require("./build_schema");
var _schemas = require("../../../../model/schemas");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO https://github.com/elastic/security-team/issues/7491
// eslint-disable-next-line no-restricted-imports

const DiffableCommonFields = exports.DiffableCommonFields = (0, _build_schema.buildSchema)({
  required: {
    // Technical fields
    // NOTE: We might consider removing them from the schema and returning from the API
    // not via the fields diff, but via dedicated properties in the response body.
    rule_id: _rule_schema_legacy.RuleSignatureId,
    version: _rule_schema_legacy.RuleVersion,
    meta: _rule_schema_legacy.RuleMetadata,
    // Main domain fields
    name: _rule_schema_legacy.RuleName,
    tags: _rule_schema_legacy.RuleTagArray,
    description: _rule_schema_legacy.RuleDescription,
    severity: _securitysolutionIoTsAlertingTypes.Severity,
    severity_mapping: _securitysolutionIoTsAlertingTypes.SeverityMapping,
    risk_score: _securitysolutionIoTsAlertingTypes.RiskScore,
    risk_score_mapping: _securitysolutionIoTsAlertingTypes.RiskScoreMapping,
    // About -> Advanced settings
    references: _rule_schema_legacy.RuleReferenceArray,
    false_positives: _rule_schema_legacy.RuleFalsePositiveArray,
    threat: _rule_schema_legacy.ThreatArray,
    note: _rule_schema_legacy.InvestigationGuide,
    setup: _rule_schema_legacy.SetupGuide,
    related_integrations: _rule_schema_legacy.RelatedIntegrationArray,
    required_fields: _rule_schema_legacy.RequiredFieldArray,
    author: _rule_schema_legacy.RuleAuthorArray,
    license: _rule_schema_legacy.RuleLicense,
    // Other domain fields
    rule_schedule: _diffable_field_types.RuleSchedule,
    // NOTE: new field
    actions: _securitysolutionIoTsAlertingTypes.RuleActionArray,
    throttle: _securitysolutionIoTsAlertingTypes.RuleActionThrottle,
    exceptions_list: _rule_schema_legacy.ExceptionListArray,
    max_signals: _rule_schema_legacy.MaxSignals
  },
  optional: {
    rule_name_override: _diffable_field_types.RuleNameOverrideObject,
    // NOTE: new field
    timestamp_override: _diffable_field_types.TimestampOverrideObject,
    // NOTE: new field
    timeline_template: _diffable_field_types.TimelineTemplateReference,
    // NOTE: new field
    building_block: _diffable_field_types.BuildingBlockObject // NOTE: new field
  }
});
const DiffableCustomQueryFields = exports.DiffableCustomQueryFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('query'),
    kql_query: _diffable_field_types.RuleKqlQuery // NOTE: new field
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    alert_suppression: _rule_schema_legacy.AlertSuppression
  }
});
const DiffableSavedQueryFields = exports.DiffableSavedQueryFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('saved_query'),
    kql_query: _diffable_field_types.RuleKqlQuery // NOTE: new field
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    alert_suppression: _rule_schema_legacy.AlertSuppression
  }
});
const DiffableEqlFields = exports.DiffableEqlFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('eql'),
    eql_query: _diffable_field_types.RuleEqlQuery // NOTE: new field
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    event_category_override: _rule_schema_legacy.EventCategoryOverride,
    timestamp_field: _rule_schema_legacy.TimestampField,
    tiebreaker_field: _rule_schema_legacy.TiebreakerField
  }
});
const DiffableEsqlFields = exports.DiffableEsqlFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('esql'),
    esql_query: _diffable_field_types.RuleEsqlQuery // NOTE: new field
  },
  // this is a new type of rule, no prebuilt rules created yet.
  // new properties might be added here during further rule type development
  optional: {}
});
const DiffableThreatMatchFields = exports.DiffableThreatMatchFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('threat_match'),
    kql_query: _diffable_field_types.RuleKqlQuery,
    // NOTE: new field
    threat_query: _diffable_field_types.InlineKqlQuery,
    // NOTE: new field
    threat_index: _securitysolutionIoTsAlertingTypes.threat_index,
    threat_mapping: _securitysolutionIoTsAlertingTypes.threat_mapping
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource,
    // NOTE: new field
    threat_indicator_path: _securitysolutionIoTsAlertingTypes.threat_indicator_path,
    concurrent_searches: _securitysolutionIoTsAlertingTypes.concurrent_searches,
    // Should combine concurrent_searches and items_per_search?
    items_per_search: _securitysolutionIoTsAlertingTypes.items_per_search
  }
});
const DiffableThresholdFields = exports.DiffableThresholdFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('threshold'),
    kql_query: _diffable_field_types.RuleKqlQuery,
    // NOTE: new field
    threshold: _rule_schema_legacy.Threshold
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource // NOTE: new field
  }
});
const DiffableMachineLearningFields = exports.DiffableMachineLearningFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('machine_learning'),
    machine_learning_job_id: _securitysolutionIoTsAlertingTypes.machine_learning_job_id,
    anomaly_threshold: _schemas.anomaly_threshold
  },
  optional: {}
});
const DiffableNewTermsFields = exports.DiffableNewTermsFields = (0, _build_schema.buildSchema)({
  required: {
    type: t.literal('new_terms'),
    kql_query: _diffable_field_types.InlineKqlQuery,
    // NOTE: new field
    new_terms_fields: _rule_schema_legacy.NewTermsFields,
    history_window_start: _rule_schema_legacy.HistoryWindowStart
  },
  optional: {
    data_source: _diffable_field_types.RuleDataSource // NOTE: new field
  }
});

/**
 * Represents a normalized rule object that is suitable for passing to the diff algorithm.
 * Every top-level field of a diffable rule can be compared separately on its own.
 *
 * It's important to do such normalization because:
 *
 * 1. We need to compare installed rules with prebuilt rule content. These objects have similar but not exactly
 * the same interfaces. In order to compare them we need to convert them to a common interface.
 *
 * 2. It only makes sense to compare certain rule fields in combination with other fields. For example,
 * we combine `index` and `data_view_id` fields into a `RuleDataSource` object, so that later we could
 * calculate a diff for this whole object. If we don't combine them the app would successfully merge the
 * following values independently from each other without a conflict:
 *
 *   Base version: index=[logs-*], data_view_id=undefined
 *   Current version: index=[], data_view_id=some-data-view // user switched to a data view
 *   Target version: index=[logs-*, filebeat-*], data_view_id=undefined // Elastic added a new index pattern
 *   Merged version: index=[filebeat-*], data_view_id=some-data-view ???
 *
 * Instead, semantically such change represents a conflict because the data source of the rule was changed
 * in a potentially incompatible way, and the user might want to review the change and resolve it manually.
 * The user must either pick index patterns or a data view, but not both at the same time.
 *
 * NOTE: Every top-level field in a DiffableRule MUST BE LOGICALLY INDEPENDENT from other
 * top-level fields.
 */

const DiffableRule = exports.DiffableRule = t.intersection([DiffableCommonFields, t.union([DiffableCustomQueryFields, DiffableSavedQueryFields, DiffableEqlFields, DiffableEsqlFields, DiffableThreatMatchFields, DiffableThresholdFields, DiffableMachineLearningFields, DiffableNewTermsFields])]);

/**
 * This is a merge of all fields from all rule types into a single TS type.
 * This is NOT a union discriminated by rule type, as DiffableRule is.
 */