"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverrideObject = exports.TimelineTemplateReference = exports.SavedKqlQuery = exports.RuleSchedule = exports.RuleNameOverrideObject = exports.RuleKqlQuery = exports.RuleEsqlQuery = exports.RuleEqlQuery = exports.RuleDataSource = exports.KqlQueryType = exports.InlineKqlQuery = exports.DataSourceType = exports.DataSourceIndexPatterns = exports.DataSourceDataView = exports.BuildingBlockObject = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _rule_schema_legacy = require("../../../../model/rule_schema_legacy");
var _schemas = require("../../../../model/schemas");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO https://github.com/elastic/security-team/issues/7491
// eslint-disable-next-line no-restricted-imports
// -------------------------------------------------------------------------------------------------
// Rule data source
let DataSourceType = exports.DataSourceType = /*#__PURE__*/function (DataSourceType) {
  DataSourceType["index_patterns"] = "index_patterns";
  DataSourceType["data_view"] = "data_view";
  return DataSourceType;
}({});
const DataSourceIndexPatterns = exports.DataSourceIndexPatterns = t.exact(t.type({
  type: t.literal(DataSourceType.index_patterns),
  index_patterns: _rule_schema_legacy.IndexPatternArray
}));
const DataSourceDataView = exports.DataSourceDataView = t.exact(t.type({
  type: t.literal(DataSourceType.data_view),
  data_view_id: _rule_schema_legacy.DataViewId
}));
const RuleDataSource = exports.RuleDataSource = t.union([DataSourceIndexPatterns, DataSourceDataView]);

// -------------------------------------------------------------------------------------------------
// Rule data query
let KqlQueryType = exports.KqlQueryType = /*#__PURE__*/function (KqlQueryType) {
  KqlQueryType["inline_query"] = "inline_query";
  KqlQueryType["saved_query"] = "saved_query";
  return KqlQueryType;
}({});
const InlineKqlQuery = exports.InlineKqlQuery = t.exact(t.type({
  type: t.literal(KqlQueryType.inline_query),
  query: _rule_schema_legacy.RuleQuery,
  language: _rule_schema_legacy.KqlQueryLanguage,
  filters: _rule_schema_legacy.RuleFilterArray
}));
const SavedKqlQuery = exports.SavedKqlQuery = t.exact(t.type({
  type: t.literal(KqlQueryType.saved_query),
  saved_query_id: _schemas.saved_id
}));
const RuleKqlQuery = exports.RuleKqlQuery = t.union([InlineKqlQuery, SavedKqlQuery]);
const RuleEqlQuery = exports.RuleEqlQuery = t.exact(t.type({
  query: _rule_schema_legacy.RuleQuery,
  language: t.literal('eql'),
  filters: _rule_schema_legacy.RuleFilterArray
}));
const RuleEsqlQuery = exports.RuleEsqlQuery = t.exact(t.type({
  query: _rule_schema_legacy.RuleQuery,
  language: t.literal('esql')
}));

// -------------------------------------------------------------------------------------------------
// Rule schedule

const RuleSchedule = exports.RuleSchedule = t.exact(t.type({
  interval: (0, _securitysolutionIoTsTypes.TimeDuration)({
    allowedUnits: ['s', 'm', 'h']
  }),
  lookback: (0, _securitysolutionIoTsTypes.TimeDuration)({
    allowedUnits: ['s', 'm', 'h']
  })
}));

// -------------------------------------------------------------------------------------------------
// Rule name override

const RuleNameOverrideObject = exports.RuleNameOverrideObject = t.exact(t.type({
  field_name: _rule_schema_legacy.RuleNameOverride
}));

// -------------------------------------------------------------------------------------------------
// Timestamp override

const TimestampOverrideObject = exports.TimestampOverrideObject = t.exact(t.type({
  field_name: _rule_schema_legacy.TimestampOverride,
  fallback_disabled: _rule_schema_legacy.TimestampOverrideFallbackDisabled
}));

// -------------------------------------------------------------------------------------------------
// Reference to a timeline template

const TimelineTemplateReference = exports.TimelineTemplateReference = t.exact(t.type({
  timeline_id: _rule_schema_legacy.TimelineTemplateId,
  timeline_title: _rule_schema_legacy.TimelineTemplateTitle
}));

// -------------------------------------------------------------------------------------------------
// Building block

const BuildingBlockObject = exports.BuildingBlockObject = t.exact(t.type({
  type: _rule_schema_legacy.BuildingBlockType
}));