"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.user_search_term = exports.status = exports.signal_status_query = exports.signal_ids = exports.saved_id = exports.savedIdOrUndefined = exports.privilege = exports.indexRecord = exports.file_name = exports.exclude_export_details = exports.conflicts = exports.anomaly_threshold = exports.alert_tags = exports.alert_tag_ids = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const file_name = exports.file_name = t.string;
const exclude_export_details = exports.exclude_export_details = t.boolean;
const saved_id = exports.saved_id = t.string;
const savedIdOrUndefined = exports.savedIdOrUndefined = t.union([saved_id, t.undefined]);
const anomaly_threshold = exports.anomaly_threshold = _securitysolutionIoTsTypes.PositiveInteger;
const status = exports.status = t.keyof({
  open: null,
  closed: null,
  acknowledged: null,
  'in-progress': null
});
const conflicts = exports.conflicts = t.keyof({
  abort: null,
  proceed: null
});
const signal_ids = exports.signal_ids = t.array(t.string);
// TODO: Can this be more strict or is this is the set of all Elastic Queries?
const signal_status_query = exports.signal_status_query = t.object;
const alert_tag_ids = exports.alert_tag_ids = t.array(t.string);
const indexRecord = exports.indexRecord = t.record(t.string, t.type({
  all: t.boolean,
  maintenance: t.boolean,
  read: t.boolean,
  create_index: t.boolean,
  index: t.boolean,
  monitor: t.boolean,
  delete: t.boolean,
  manage: t.boolean,
  delete_index: t.boolean,
  create_doc: t.boolean,
  view_index_metadata: t.boolean,
  create: t.boolean,
  write: t.boolean
}));
const privilege = exports.privilege = t.type({
  username: t.string,
  has_all_requested: t.boolean,
  cluster: t.type({
    monitor_ml: t.boolean,
    manage_index_templates: t.boolean,
    monitor_transform: t.boolean,
    manage_security: t.boolean,
    manage_own_api_key: t.boolean,
    all: t.boolean,
    monitor: t.boolean,
    manage: t.boolean,
    manage_transform: t.boolean,
    manage_ml: t.boolean,
    manage_pipeline: t.boolean
  }),
  index: indexRecord,
  is_authenticated: t.boolean,
  has_encryption_key: t.boolean
});
const alert_tags = exports.alert_tags = t.type({
  tags_to_add: t.array(t.string),
  tags_to_remove: t.array(t.string)
});
const user_search_term = exports.user_search_term = t.string;