"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orUndefined = exports.buildRuleSchemas = exports.baseSchema = exports.TypeSpecificCreateProps = exports.SharedCreateProps = exports.RuleExecutionMetrics = exports.KqlQueryLanguage = exports.EsqlQueryLanguage = exports.EqlQueryLanguage = exports.DurationMetric = exports.BaseCreateProps = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _response_actions = require("./response_actions");
var _schemas = require("../schemas");
var _common_attributes = require("./common_attributes");
var _eql_attributes = require("./eql_attributes");
var _new_terms_attributes = require("./new_terms_attributes");
var _query_attributes = require("./query_attributes");
var _threshold_attributes = require("./threshold_attributes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildRuleSchemas = ({
  required,
  optional,
  defaultable
}) => ({
  create: t.intersection([t.exact(t.type(required)), t.exact(t.partial(optional)), t.exact(t.partial(defaultable))]),
  patch: t.intersection([t.partial(required), t.partial(optional), t.partial(defaultable)]),
  response: t.intersection([t.exact(t.type(required)),
  // This bit of logic is to force all fields to be accounted for in conversions from the internal
  // rule schema to the response schema. Rather than use `t.partial`, which makes each field optional,
  // we make each field required but possibly undefined. The result is that if a field is forgotten in
  // the conversion from internal schema to response schema TS will report an error. If we just used t.partial
  // instead, then optional fields can be accidentally omitted from the conversion - and any actual values
  // in those fields internally will be stripped in the response.
  t.exact(t.type(orUndefined(optional))), t.exact(t.type(defaultable))])
});
exports.buildRuleSchemas = buildRuleSchemas;
const orUndefined = props => {
  return Object.keys(props).reduce((acc, key) => {
    acc[key] = t.union([props[key], t.undefined]);
    return acc;
  }, {});
};

// -------------------------------------------------------------------------------------------------
// Base schema
exports.orUndefined = orUndefined;
const baseSchema = exports.baseSchema = buildRuleSchemas({
  required: {
    name: _common_attributes.RuleName,
    description: _common_attributes.RuleDescription,
    risk_score: _securitysolutionIoTsAlertingTypes.RiskScore,
    severity: _securitysolutionIoTsAlertingTypes.Severity
  },
  optional: {
    // Field overrides
    rule_name_override: _common_attributes.RuleNameOverride,
    timestamp_override: _common_attributes.TimestampOverride,
    timestamp_override_fallback_disabled: _common_attributes.TimestampOverrideFallbackDisabled,
    // Timeline template
    timeline_id: _common_attributes.TimelineTemplateId,
    timeline_title: _common_attributes.TimelineTemplateTitle,
    // Attributes related to SavedObjectsClient.resolve API
    outcome: _common_attributes.SavedObjectResolveOutcome,
    alias_target_id: _common_attributes.SavedObjectResolveAliasTargetId,
    alias_purpose: _common_attributes.SavedObjectResolveAliasPurpose,
    // Misc attributes
    license: _common_attributes.RuleLicense,
    note: _common_attributes.InvestigationGuide,
    building_block_type: _common_attributes.BuildingBlockType,
    output_index: _common_attributes.AlertsIndex,
    namespace: _common_attributes.AlertsIndexNamespace,
    meta: _common_attributes.RuleMetadata,
    investigation_fields: _common_attributes.InvestigationFields,
    // Throttle
    throttle: _securitysolutionIoTsAlertingTypes.RuleActionThrottle
  },
  defaultable: {
    // Main attributes
    version: _common_attributes.RuleVersion,
    tags: _common_attributes.RuleTagArray,
    enabled: _common_attributes.IsRuleEnabled,
    // Field overrides
    risk_score_mapping: _securitysolutionIoTsAlertingTypes.RiskScoreMapping,
    severity_mapping: _securitysolutionIoTsAlertingTypes.SeverityMapping,
    // Rule schedule
    interval: _securitysolutionIoTsAlertingTypes.RuleInterval,
    from: _securitysolutionIoTsAlertingTypes.RuleIntervalFrom,
    to: _securitysolutionIoTsAlertingTypes.RuleIntervalTo,
    // Rule actions
    actions: _securitysolutionIoTsAlertingTypes.RuleActionArray,
    // Rule exceptions
    exceptions_list: _common_attributes.ExceptionListArray,
    // Misc attributes
    author: _common_attributes.RuleAuthorArray,
    false_positives: _common_attributes.RuleFalsePositiveArray,
    references: _common_attributes.RuleReferenceArray,
    // maxSignals not used in ML rules but probably should be used
    max_signals: _common_attributes.MaxSignals,
    threat: _common_attributes.ThreatArray
  }
});
const DurationMetric = exports.DurationMetric = _securitysolutionIoTsTypes.PositiveInteger;
/**
  @property total_search_duration_ms - "total time spent performing ES searches as measured by Kibana; 
  includes network latency and time spent serializing/deserializing request/response",
  @property total_indexing_duration_ms - "total time spent indexing documents during current rule execution cycle",
  @property total_enrichment_duration_ms - total time spent enriching documents during current rule execution cycle
  @property execution_gap_duration_s - "duration in seconds of execution gap"
*/
const RuleExecutionMetrics = exports.RuleExecutionMetrics = t.partial({
  total_search_duration_ms: DurationMetric,
  total_indexing_duration_ms: DurationMetric,
  total_enrichment_duration_ms: DurationMetric,
  execution_gap_duration_s: DurationMetric
});
const BaseCreateProps = exports.BaseCreateProps = baseSchema.create;

// -------------------------------------------------------------------------------------------------
// Shared schemas

// "Shared" types are the same across all rule types, and built from "baseSchema" above
// with some variations for each route. These intersect with type specific schemas below
// to create the full schema for each route.

const SharedCreateProps = exports.SharedCreateProps = t.intersection([baseSchema.create, t.exact(t.partial({
  rule_id: _common_attributes.RuleSignatureId
}))]);

// -------------------------------------------------------------------------------------------------
// EQL rule schema

const KqlQueryLanguage = exports.KqlQueryLanguage = t.keyof({
  kuery: null,
  lucene: null
});
const EqlQueryLanguage = exports.EqlQueryLanguage = t.literal('eql');
const eqlSchema = buildRuleSchemas({
  required: {
    type: t.literal('eql'),
    language: EqlQueryLanguage,
    query: _common_attributes.RuleQuery
  },
  optional: {
    index: _common_attributes.IndexPatternArray,
    data_view_id: _common_attributes.DataViewId,
    filters: _common_attributes.RuleFilterArray,
    timestamp_field: _eql_attributes.TimestampField,
    event_category_override: _eql_attributes.EventCategoryOverride,
    tiebreaker_field: _eql_attributes.TiebreakerField
  },
  defaultable: {}
});

// -------------------------------------------------------------------------------------------------
// ES|QL rule schema

const EsqlQueryLanguage = exports.EsqlQueryLanguage = t.literal('esql');
const esqlSchema = buildRuleSchemas({
  required: {
    type: t.literal('esql'),
    language: EsqlQueryLanguage,
    query: _common_attributes.RuleQuery
  },
  optional: {},
  defaultable: {}
});

// -------------------------------------------------------------------------------------------------
// Indicator Match rule schema

const threatMatchSchema = buildRuleSchemas({
  required: {
    type: t.literal('threat_match'),
    query: _common_attributes.RuleQuery,
    threat_query: _securitysolutionIoTsAlertingTypes.threat_query,
    threat_mapping: _securitysolutionIoTsAlertingTypes.threat_mapping,
    threat_index: _securitysolutionIoTsAlertingTypes.threat_index
  },
  optional: {
    index: _common_attributes.IndexPatternArray,
    data_view_id: _common_attributes.DataViewId,
    filters: _common_attributes.RuleFilterArray,
    saved_id: _schemas.saved_id,
    threat_filters: _securitysolutionIoTsAlertingTypes.threat_filters,
    threat_indicator_path: _securitysolutionIoTsAlertingTypes.threat_indicator_path,
    threat_language: KqlQueryLanguage,
    concurrent_searches: _securitysolutionIoTsAlertingTypes.concurrent_searches,
    items_per_search: _securitysolutionIoTsAlertingTypes.items_per_search
  },
  defaultable: {
    language: KqlQueryLanguage
  }
});

// -------------------------------------------------------------------------------------------------
// Custom Query rule schema

const querySchema = buildRuleSchemas({
  required: {
    type: t.literal('query')
  },
  optional: {
    index: _common_attributes.IndexPatternArray,
    data_view_id: _common_attributes.DataViewId,
    filters: _common_attributes.RuleFilterArray,
    saved_id: _schemas.saved_id,
    response_actions: _response_actions.ResponseActionArray,
    alert_suppression: _query_attributes.AlertSuppression
  },
  defaultable: {
    query: _common_attributes.RuleQuery,
    language: KqlQueryLanguage
  }
});

// -------------------------------------------------------------------------------------------------
// Saved Query rule schema

const savedQuerySchema = buildRuleSchemas({
  required: {
    type: t.literal('saved_query'),
    saved_id: _schemas.saved_id
  },
  optional: {
    // Having language, query, and filters possibly defined adds more code confusion and probably user confusion
    // if the saved object gets deleted for some reason
    index: _common_attributes.IndexPatternArray,
    data_view_id: _common_attributes.DataViewId,
    query: _common_attributes.RuleQuery,
    filters: _common_attributes.RuleFilterArray,
    response_actions: _response_actions.ResponseActionArray,
    alert_suppression: _query_attributes.AlertSuppression
  },
  defaultable: {
    language: KqlQueryLanguage
  }
});

// -------------------------------------------------------------------------------------------------
// Threshold rule schema

const thresholdSchema = buildRuleSchemas({
  required: {
    type: t.literal('threshold'),
    query: _common_attributes.RuleQuery,
    threshold: _threshold_attributes.Threshold
  },
  optional: {
    index: _common_attributes.IndexPatternArray,
    data_view_id: _common_attributes.DataViewId,
    filters: _common_attributes.RuleFilterArray,
    saved_id: _schemas.saved_id
  },
  defaultable: {
    language: KqlQueryLanguage
  }
});

// -------------------------------------------------------------------------------------------------
// Machine Learning rule schema

const machineLearningSchema = buildRuleSchemas({
  required: {
    type: t.literal('machine_learning'),
    anomaly_threshold: _schemas.anomaly_threshold,
    machine_learning_job_id: _securitysolutionIoTsAlertingTypes.machine_learning_job_id
  },
  optional: {},
  defaultable: {}
});

// -------------------------------------------------------------------------------------------------
// New Terms rule schema

const newTermsSchema = buildRuleSchemas({
  required: {
    type: t.literal('new_terms'),
    query: _common_attributes.RuleQuery,
    new_terms_fields: _new_terms_attributes.NewTermsFields,
    history_window_start: _new_terms_attributes.HistoryWindowStart
  },
  optional: {
    index: _common_attributes.IndexPatternArray,
    data_view_id: _common_attributes.DataViewId,
    filters: _common_attributes.RuleFilterArray
  },
  defaultable: {
    language: KqlQueryLanguage
  }
});

// -------------------------------------------------------------------------------------------------
// Combined type specific schemas

const TypeSpecificCreateProps = exports.TypeSpecificCreateProps = t.union([eqlSchema.create, esqlSchema.create, threatMatchSchema.create, querySchema.create, savedQuerySchema.create, thresholdSchema.create, machineLearningSchema.create, newTermsSchema.create]);