"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleResponseOsqueryAction = exports.RuleResponseEndpointAction = exports.ResponseActionRuleParamsOrUndefined = exports.ResponseActionArray = exports.ResponseAction = exports.OsqueryParamsCamelCase = exports.OsqueryParams = exports.EndpointParams = void 0;
var _osqueryIoTsTypes = require("@kbn/osquery-io-ts-types");
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// to enable using RESPONSE_ACTION_API_COMMANDS_NAMES as a type
function keyObject(arr) {
  return Object.fromEntries(arr.map(v => [v, null]));
}
const EndpointParams = exports.EndpointParams = t.type({
  // TODO: TC- change these when we go GA with automated process actions
  command: t.keyof(keyObject(['isolate', 'kill-process', 'suspend-process'])),
  // command: t.keyof(keyObject(ENABLED_AUTOMATED_RESPONSE_ACTION_COMMANDS)),
  comment: t.union([t.string, t.undefined])
});
const OsqueryParams = exports.OsqueryParams = t.type({
  query: t.union([t.string, t.undefined]),
  ecs_mapping: t.union([_osqueryIoTsTypes.ecsMapping, t.undefined]),
  queries: t.union([_osqueryIoTsTypes.arrayQueries, t.undefined]),
  pack_id: t.union([t.string, t.undefined]),
  saved_query_id: t.union([t.string, t.undefined])
});
const OsqueryParamsCamelCase = exports.OsqueryParamsCamelCase = t.type({
  query: t.union([t.string, t.undefined]),
  ecsMapping: t.union([_osqueryIoTsTypes.ecsMapping, t.undefined]),
  queries: t.union([_osqueryIoTsTypes.arrayQueries, t.undefined]),
  packId: t.union([t.string, t.undefined]),
  savedQueryId: t.union([t.string, t.undefined])
});

// When we create new response action types, create a union of types

const RuleResponseOsqueryAction = exports.RuleResponseOsqueryAction = t.strict({
  actionTypeId: t.literal('.osquery'),
  params: OsqueryParamsCamelCase
});
const RuleResponseEndpointAction = exports.RuleResponseEndpointAction = t.strict({
  actionTypeId: t.literal('.endpoint'),
  params: EndpointParams
});
const ResponseActionRuleParam = t.union([RuleResponseOsqueryAction, RuleResponseEndpointAction]);
const ResponseActionRuleParamsOrUndefined = exports.ResponseActionRuleParamsOrUndefined = t.union([t.array(ResponseActionRuleParam), t.undefined]);

// When we create new response action types, create a union of types
const OsqueryResponseAction = t.strict({
  action_type_id: t.literal('.osquery'),
  params: OsqueryParams
});
const EndpointResponseAction = t.strict({
  action_type_id: t.literal('.endpoint'),
  params: EndpointParams
});
const ResponseAction = exports.ResponseAction = t.union([OsqueryResponseAction, EndpointResponseAction]);
const ResponseActionArray = exports.ResponseActionArray = t.array(ResponseAction);