"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionMissingFields = exports.AlertSuppressionGroupBy = exports.AlertSuppressionDuration = exports.AlertSuppressionCamel = exports.AlertSuppression = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _common_attributes = require("../rule_schema/common_attributes.gen");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSuppressionMissingFields = exports.AlertSuppressionMissingFields = (0, _securitysolutionIoTsTypes.enumeration)('AlertSuppressionMissingFields', _common_attributes.AlertSuppressionMissingFieldsStrategyEnum);
const AlertSuppressionGroupBy = exports.AlertSuppressionGroupBy = (0, _securitysolutionIoTsTypes.LimitedSizeArray)({
  codec: t.string,
  minSize: 1,
  maxSize: 3
});
const AlertSuppressionDuration = exports.AlertSuppressionDuration = t.type({
  value: _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero,
  unit: t.keyof({
    s: null,
    m: null,
    h: null
  })
});

/**
 * Schema for fields relating to alert suppression, which enables limiting the number of alerts per entity.
 * e.g. group_by: ['host.name'] would create only one alert per value of host.name. The created alert
 * contains metadata about how many other candidate alerts with the same host.name value were suppressed.
 */

const AlertSuppression = exports.AlertSuppression = t.intersection([t.exact(t.type({
  group_by: AlertSuppressionGroupBy
})), t.exact(t.partial({
  duration: AlertSuppressionDuration,
  missing_fields_strategy: AlertSuppressionMissingFields
}))]);
const AlertSuppressionCamel = exports.AlertSuppressionCamel = t.intersection([t.exact(t.type({
  groupBy: AlertSuppressionGroupBy
})), t.exact(t.partial({
  duration: AlertSuppressionDuration,
  missingFieldsStrategy: AlertSuppressionMissingFields
}))]);