"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverrideFallbackDisabled = exports.TimestampOverride = exports.TimelineTemplateTitle = exports.TimelineTemplateId = exports.ThreatArray = exports.SetupGuide = exports.SavedObjectResolveOutcome = exports.SavedObjectResolveAliasTargetId = exports.SavedObjectResolveAliasPurpose = exports.RuleVersion = exports.RuleTagArray = exports.RuleSignatureId = exports.RuleReferenceArray = exports.RuleQuery = exports.RuleObjectId = exports.RuleNameOverride = exports.RuleName = exports.RuleMetadata = exports.RuleLicense = exports.RuleFilterArray = exports.RuleFalsePositiveArray = exports.RuleDescription = exports.RuleAuthorArray = exports.RequiredFieldArray = exports.RequiredField = exports.RelatedIntegrationArray = exports.RelatedIntegration = exports.MaxSignals = exports.IsRuleImmutable = exports.IsRuleEnabled = exports.InvestigationGuide = exports.InvestigationFields = exports.IndexPatternArray = exports.ExceptionListArray = exports.DataViewId = exports.BuildingBlockType = exports.AlertsIndexNamespace = exports.AlertsIndex = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleObjectId = exports.RuleObjectId = _securitysolutionIoTsTypes.UUID;

/**
 * NOTE: Never make this a strict uuid, we allow the rule_id to be any string at the moment
 * in case we encounter 3rd party rule systems which might be using auto incrementing numbers
 * or other different things.
 */

const RuleSignatureId = exports.RuleSignatureId = t.string; // should be non-empty string?

const RuleName = exports.RuleName = _securitysolutionIoTsTypes.NonEmptyString;
const RuleDescription = exports.RuleDescription = _securitysolutionIoTsTypes.NonEmptyString;
const RuleVersion = exports.RuleVersion = _securitysolutionIoTsTypes.version;
const IsRuleImmutable = exports.IsRuleImmutable = t.boolean;
const IsRuleEnabled = exports.IsRuleEnabled = t.boolean;
const RuleTagArray = exports.RuleTagArray = t.array(t.string); // should be non-empty strings?

/**
 * Note that this is a non-exact io-ts type as we allow extra meta information
 * to be added to the meta object
 */

const RuleMetadata = exports.RuleMetadata = t.UnknownRecord; // should be a more specific type?

const RuleLicense = exports.RuleLicense = t.string;
const RuleAuthorArray = exports.RuleAuthorArray = t.array(t.string); // should be non-empty strings?

const RuleFalsePositiveArray = exports.RuleFalsePositiveArray = t.array(t.string); // should be non-empty strings?

const RuleReferenceArray = exports.RuleReferenceArray = t.array(t.string); // should be non-empty strings?

const InvestigationGuide = exports.InvestigationGuide = t.string;

/**
 * Any instructions for the user for setting up their environment in order to start receiving
 * source events for a given rule.
 *
 * It's a multiline text. Markdown is supported.
 */

const SetupGuide = exports.SetupGuide = t.string;
const BuildingBlockType = exports.BuildingBlockType = t.string;
const AlertsIndex = exports.AlertsIndex = t.string;
const AlertsIndexNamespace = exports.AlertsIndexNamespace = t.string;
const ExceptionListArray = exports.ExceptionListArray = _securitysolutionIoTsListTypes.listArray;
const MaxSignals = exports.MaxSignals = _securitysolutionIoTsAlertingTypes.max_signals;
const ThreatArray = exports.ThreatArray = t.array(_securitysolutionIoTsAlertingTypes.threat);
const IndexPatternArray = exports.IndexPatternArray = t.array(t.string);
const DataViewId = exports.DataViewId = t.string;
const RuleQuery = exports.RuleQuery = t.string;

/**
 * TODO: Right now the filters is an "unknown", when it could more than likely
 * become the actual ESFilter as a type.
 */

// Filters are not easily type-able yet
const RuleFilterArray = exports.RuleFilterArray = t.array(t.unknown); // Filters are not easily type-able yet

const RuleNameOverride = exports.RuleNameOverride = t.string; // should be non-empty string?

const TimestampOverride = exports.TimestampOverride = t.string; // should be non-empty string?

const TimestampOverrideFallbackDisabled = exports.TimestampOverrideFallbackDisabled = t.boolean;

/**
 * Almost all types of Security rules check source event documents for a match to some kind of
 * query or filter. If a document has certain field with certain values, then it's a match and
 * the rule will generate an alert.
 *
 * Required field is an event field that must be present in the source indices of a given rule.
 *
 * @example
 * const standardEcsField: RequiredField = {
 *   name: 'event.action',
 *   type: 'keyword',
 *   ecs: true,
 * };
 *
 * @example
 * const nonEcsField: RequiredField = {
 *   name: 'winlog.event_data.AttributeLDAPDisplayName',
 *   type: 'keyword',
 *   ecs: false,
 * };
 */

const RequiredField = exports.RequiredField = t.exact(t.type({
  name: _securitysolutionIoTsTypes.NonEmptyString,
  type: _securitysolutionIoTsTypes.NonEmptyString,
  ecs: t.boolean
}));

/**
 * Array of event fields that must be present in the source indices of a given rule.
 *
 * @example
 * const x: RequiredFieldArray = [
 *   {
 *     name: 'event.action',
 *     type: 'keyword',
 *     ecs: true,
 *   },
 *   {
 *     name: 'event.code',
 *     type: 'keyword',
 *     ecs: true,
 *   },
 *   {
 *     name: 'winlog.event_data.AttributeLDAPDisplayName',
 *     type: 'keyword',
 *     ecs: false,
 *   },
 * ];
 */

const RequiredFieldArray = exports.RequiredFieldArray = t.array(RequiredField);
const TimelineTemplateId = exports.TimelineTemplateId = t.string; // should be non-empty string?

const TimelineTemplateTitle = exports.TimelineTemplateTitle = t.string; // should be non-empty string?

/**
 * Outcome is a property of the saved object resolve api
 * will tell us info about the rule after 8.0 migrations
 */

const SavedObjectResolveOutcome = exports.SavedObjectResolveOutcome = t.union([t.literal('exactMatch'), t.literal('aliasMatch'), t.literal('conflict')]);
const SavedObjectResolveAliasTargetId = exports.SavedObjectResolveAliasTargetId = t.string;
const SavedObjectResolveAliasPurpose = exports.SavedObjectResolveAliasPurpose = t.union([t.literal('savedObjectConversion'), t.literal('savedObjectImport')]);

/**
 * Related integration is a potential dependency of a rule. It's assumed that if the user installs
 * one of the related integrations of a rule, the rule might start to work properly because it will
 * have source events (generated by this integration) potentially matching the rule's query.
 *
 *   NOTE: Proper work is not guaranteed, because a related integration, if installed, can be
 *   configured differently or generate data that is not necessarily relevant for this rule.
 *
 * Related integration is a combination of a Fleet package and (optionally) one of the
 * package's "integrations" that this package contains. It is represented by 3 properties:
 *
 *   - `package`: name of the package (required, unique id)
 *   - `version`: version of the package (required, semver-compatible)
 *   - `integration`: name of the integration of this package (optional, id within the package)
 *
 * There are Fleet packages like `windows` that contain only one integration; in this case,
 * `integration` should be unspecified. There are also packages like `aws` and `azure` that contain
 * several integrations; in this case, `integration` should be specified.
 *
 * @example
 * const x: RelatedIntegration = {
 *   package: 'windows',
 *   version: '1.5.x',
 * };
 *
 * @example
 * const x: RelatedIntegration = {
 *   package: 'azure',
 *   version: '~1.1.6',
 *   integration: 'activitylogs',
 * };
 */

const RelatedIntegration = exports.RelatedIntegration = t.exact(t.intersection([t.type({
  package: _securitysolutionIoTsTypes.NonEmptyString,
  version: _securitysolutionIoTsTypes.NonEmptyString
}), t.partial({
  integration: _securitysolutionIoTsTypes.NonEmptyString
})]));

/**
 * Array of related integrations.
 *
 * @example
 * const x: RelatedIntegrationArray = [
 *   {
 *     package: 'windows',
 *     version: '1.5.x',
 *   },
 *   {
 *     package: 'azure',
 *     version: '~1.1.6',
 *     integration: 'activitylogs',
 *   },
 * ];
 */

const RelatedIntegrationArray = exports.RelatedIntegrationArray = t.array(RelatedIntegration);

/**
 * Schema for fields relating to investigation fields, these are user defined fields we use to highlight
 * in various features in the UI such as alert details flyout and exceptions auto-population from alert.
 * Added in PR #163235
 * Right now we only have a single field but anticipate adding more related fields to store various
 * configuration states such as `override` - where a user might say if they want only these fields to
 * display, or if they want these fields + the fields we select. When expanding this field, it may look
 * something like:
 * export const investigationFields = t.intersection([
 * t.exact(
 *   t.type({
 *     field_names: NonEmptyArray(NonEmptyString),
 *   })
 * ),
 * t.exact(
 *   t.partial({
 *     overide: t.boolean,
 *   })
 * ),
 * ]);
 *
 */

const InvestigationFields = exports.InvestigationFields = t.exact(t.type({
  field_names: (0, _securitysolutionIoTsTypes.NonEmptyArray)(_securitysolutionIoTsTypes.NonEmptyString)
}));