"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdWithCardinality = exports.ThresholdValue = exports.ThresholdNormalized = exports.ThresholdFieldNormalized = exports.ThresholdField = exports.ThresholdCardinality = exports.ThresholdAlertSuppression = exports.Threshold = void 0;
var _zod = require("zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Threshold Rule Attributes
 *   version: not applicable
 */

const ThresholdCardinality = exports.ThresholdCardinality = _zod.z.array(_zod.z.object({
  field: _zod.z.string(),
  value: _zod.z.number().int().min(0)
}));

/**
 * Threshold value
 */

const ThresholdValue = exports.ThresholdValue = _zod.z.number().int().min(1);

/**
 * Field to aggregate on
 */

const ThresholdField = exports.ThresholdField = _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]);

/**
 * Field to aggregate on
 */

const ThresholdFieldNormalized = exports.ThresholdFieldNormalized = _zod.z.array(_zod.z.string());
const Threshold = exports.Threshold = _zod.z.object({
  field: ThresholdField,
  value: ThresholdValue,
  cardinality: ThresholdCardinality.optional()
});
const ThresholdNormalized = exports.ThresholdNormalized = _zod.z.object({
  field: ThresholdFieldNormalized,
  value: ThresholdValue,
  cardinality: ThresholdCardinality.optional()
});
const ThresholdWithCardinality = exports.ThresholdWithCardinality = _zod.z.object({
  field: ThresholdFieldNormalized,
  value: ThresholdValue,
  cardinality: ThresholdCardinality
});
const ThresholdAlertSuppression = exports.ThresholdAlertSuppression = _zod.z.object({
  duration: _common_attributes.AlertSuppressionDuration
});