"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatQuery = exports.ThreatMapping = exports.ThreatIndicatorPath = exports.ThreatIndex = exports.ThreatFilters = exports.ItemsPerSearch = exports.ConcurrentSearches = void 0;
var _zod = require("zod");
var _primitives = require("../../../../model/primitives.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Threat Match Rule Attributes
 *   version: not applicable
 */

/**
 * Query to execute
 */

const ThreatQuery = exports.ThreatQuery = _zod.z.string();
const ThreatMapping = exports.ThreatMapping = _zod.z.array(_zod.z.object({
  entries: _zod.z.array(_zod.z.object({
    field: _primitives.NonEmptyString,
    type: _zod.z.literal('mapping'),
    value: _primitives.NonEmptyString
  }))
})).min(1);
const ThreatIndex = exports.ThreatIndex = _zod.z.array(_zod.z.string());
const ThreatFilters = exports.ThreatFilters = _zod.z.array(_zod.z.unknown());

/**
 * Defines the path to the threat indicator in the indicator documents (optional)
 */

const ThreatIndicatorPath = exports.ThreatIndicatorPath = _zod.z.string();
const ConcurrentSearches = exports.ConcurrentSearches = _zod.z.number().int().min(1);
const ItemsPerSearch = exports.ItemsPerSearch = _zod.z.number().int().min(1);