"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeSpecificResponse = exports.TypeSpecificPatchProps = exports.TypeSpecificCreateProps = exports.ThresholdRuleUpdateProps = exports.ThresholdRuleResponseFields = exports.ThresholdRuleRequiredFields = exports.ThresholdRulePatchProps = exports.ThresholdRulePatchFields = exports.ThresholdRuleOptionalFields = exports.ThresholdRuleDefaultableFields = exports.ThresholdRuleCreateProps = exports.ThresholdRuleCreateFields = exports.ThresholdRule = exports.ThreatMatchRuleUpdateProps = exports.ThreatMatchRuleResponseFields = exports.ThreatMatchRuleRequiredFields = exports.ThreatMatchRulePatchProps = exports.ThreatMatchRulePatchFields = exports.ThreatMatchRuleOptionalFields = exports.ThreatMatchRuleDefaultableFields = exports.ThreatMatchRuleCreateProps = exports.ThreatMatchRuleCreateFields = exports.ThreatMatchRule = exports.SharedUpdateProps = exports.SharedResponseProps = exports.SharedPatchProps = exports.SharedCreateProps = exports.SavedQueryRuleUpdateProps = exports.SavedQueryRuleResponseFields = exports.SavedQueryRuleRequiredFields = exports.SavedQueryRulePatchProps = exports.SavedQueryRulePatchFields = exports.SavedQueryRuleOptionalFields = exports.SavedQueryRuleDefaultableFields = exports.SavedQueryRuleCreateProps = exports.SavedQueryRuleCreateFields = exports.SavedQueryRule = exports.RuleUpdateProps = exports.RuleResponse = exports.RulePatchProps = exports.RuleCreateProps = exports.ResponseFields = exports.QueryRuleUpdateProps = exports.QueryRuleResponseFields = exports.QueryRuleRequiredFields = exports.QueryRulePatchProps = exports.QueryRulePatchFields = exports.QueryRuleOptionalFields = exports.QueryRuleDefaultableFields = exports.QueryRuleCreateProps = exports.QueryRuleCreateFields = exports.QueryRule = exports.NewTermsRuleUpdateProps = exports.NewTermsRuleResponseFields = exports.NewTermsRuleRequiredFields = exports.NewTermsRulePatchProps = exports.NewTermsRulePatchFields = exports.NewTermsRuleOptionalFields = exports.NewTermsRuleDefaultableFields = exports.NewTermsRuleCreateProps = exports.NewTermsRuleCreateFields = exports.NewTermsRule = exports.MachineLearningRuleUpdateProps = exports.MachineLearningRuleResponseFields = exports.MachineLearningRuleRequiredFields = exports.MachineLearningRulePatchProps = exports.MachineLearningRulePatchFields = exports.MachineLearningRuleCreateProps = exports.MachineLearningRuleCreateFields = exports.MachineLearningRule = exports.EsqlRuleUpdateProps = exports.EsqlRuleResponseFields = exports.EsqlRuleRequiredFields = exports.EsqlRulePatchProps = exports.EsqlRulePatchFields = exports.EsqlRuleCreateProps = exports.EsqlRuleCreateFields = exports.EsqlRule = exports.EsqlQueryLanguage = exports.EqlRuleUpdateProps = exports.EqlRuleResponseFields = exports.EqlRulePatchProps = exports.EqlRulePatchFields = exports.EqlRuleCreateProps = exports.EqlRuleCreateFields = exports.EqlRule = exports.EqlRequiredFields = exports.EqlQueryLanguage = exports.EqlOptionalFields = exports.BaseResponseProps = exports.BaseRequiredFields = exports.BasePatchProps = exports.BaseOptionalFields = exports.BaseDefaultableFields = exports.BaseCreateProps = void 0;
var _zod = require("zod");
var _common_attributes = require("./common_attributes.gen");
var _execution_summary = require("../../rule_monitoring/model/execution_summary.gen");
var _eql_attributes = require("./specific_attributes/eql_attributes.gen");
var _response_actions = require("../rule_response_actions/response_actions.gen");
var _threshold_attributes = require("./specific_attributes/threshold_attributes.gen");
var _threat_match_attributes = require("./specific_attributes/threat_match_attributes.gen");
var _ml_attributes = require("./specific_attributes/ml_attributes.gen");
var _new_terms_attributes = require("./specific_attributes/new_terms_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Security Rule Schema
 *   version: not applicable
 */

const BaseRequiredFields = exports.BaseRequiredFields = _zod.z.object({
  name: _common_attributes.RuleName,
  description: _common_attributes.RuleDescription,
  risk_score: _common_attributes.RiskScore,
  severity: _common_attributes.Severity
});
const BaseOptionalFields = exports.BaseOptionalFields = _zod.z.object({
  rule_name_override: _common_attributes.RuleNameOverride.optional(),
  timestamp_override: _common_attributes.TimestampOverride.optional(),
  timestamp_override_fallback_disabled: _common_attributes.TimestampOverrideFallbackDisabled.optional(),
  timeline_id: _common_attributes.TimelineTemplateId.optional(),
  timeline_title: _common_attributes.TimelineTemplateTitle.optional(),
  outcome: _common_attributes.SavedObjectResolveOutcome.optional(),
  alias_target_id: _common_attributes.SavedObjectResolveAliasTargetId.optional(),
  alias_purpose: _common_attributes.SavedObjectResolveAliasPurpose.optional(),
  license: _common_attributes.RuleLicense.optional(),
  note: _common_attributes.InvestigationGuide.optional(),
  building_block_type: _common_attributes.BuildingBlockType.optional(),
  output_index: _common_attributes.AlertsIndex.optional(),
  namespace: _common_attributes.AlertsIndexNamespace.optional(),
  meta: _common_attributes.RuleMetadata.optional(),
  investigation_fields: _common_attributes.InvestigationFields.optional(),
  throttle: _common_attributes.RuleActionThrottle.optional()
});
const BaseDefaultableFields = exports.BaseDefaultableFields = _zod.z.object({
  version: _common_attributes.RuleVersion.optional(),
  tags: _common_attributes.RuleTagArray.optional(),
  enabled: _common_attributes.IsRuleEnabled.optional(),
  risk_score_mapping: _common_attributes.RiskScoreMapping.optional(),
  severity_mapping: _common_attributes.SeverityMapping.optional(),
  interval: _common_attributes.RuleInterval.optional(),
  from: _common_attributes.RuleIntervalFrom.optional(),
  to: _common_attributes.RuleIntervalTo.optional(),
  actions: _zod.z.array(_common_attributes.RuleAction).optional(),
  exceptions_list: _zod.z.array(_common_attributes.RuleExceptionList).optional(),
  author: _common_attributes.RuleAuthorArray.optional(),
  false_positives: _common_attributes.RuleFalsePositiveArray.optional(),
  references: _common_attributes.RuleReferenceArray.optional(),
  max_signals: _common_attributes.MaxSignals.optional(),
  threat: _common_attributes.ThreatArray.optional(),
  setup: _common_attributes.SetupGuide.optional()
});
const BaseCreateProps = exports.BaseCreateProps = BaseRequiredFields.merge(BaseOptionalFields).merge(BaseDefaultableFields);
const BasePatchProps = exports.BasePatchProps = BaseRequiredFields.partial().merge(BaseOptionalFields).merge(BaseDefaultableFields);
const BaseResponseProps = exports.BaseResponseProps = BaseRequiredFields.merge(BaseOptionalFields).merge(BaseDefaultableFields.required());
const ResponseFields = exports.ResponseFields = _zod.z.object({
  id: _common_attributes.RuleObjectId,
  rule_id: _common_attributes.RuleSignatureId,
  immutable: _common_attributes.IsRuleImmutable,
  updated_at: _zod.z.string().datetime(),
  updated_by: _zod.z.string(),
  created_at: _zod.z.string().datetime(),
  created_by: _zod.z.string(),
  revision: _zod.z.number().int().min(0),
  related_integrations: _common_attributes.RelatedIntegrationArray,
  required_fields: _common_attributes.RequiredFieldArray,
  execution_summary: _execution_summary.RuleExecutionSummary.optional()
});
const SharedCreateProps = exports.SharedCreateProps = BaseCreateProps.merge(_zod.z.object({
  rule_id: _common_attributes.RuleSignatureId.optional()
}));
const SharedUpdateProps = exports.SharedUpdateProps = BaseCreateProps.merge(_zod.z.object({
  id: _common_attributes.RuleObjectId.optional(),
  rule_id: _common_attributes.RuleSignatureId.optional()
}));
const SharedPatchProps = exports.SharedPatchProps = BasePatchProps.merge(_zod.z.object({
  id: _common_attributes.RuleObjectId.optional(),
  rule_id: _common_attributes.RuleSignatureId.optional()
}));
const SharedResponseProps = exports.SharedResponseProps = BaseResponseProps.merge(ResponseFields);
const EqlQueryLanguage = exports.EqlQueryLanguage = _zod.z.literal('eql');
const EqlRequiredFields = exports.EqlRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('eql'),
  /**
   * EQL query to execute
   */
  query: _common_attributes.RuleQuery,
  /**
   * Query language to use
   */
  language: EqlQueryLanguage
});
const EqlOptionalFields = exports.EqlOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  event_category_override: _eql_attributes.EventCategoryOverride.optional(),
  tiebreaker_field: _eql_attributes.TiebreakerField.optional(),
  timestamp_field: _eql_attributes.TimestampField.optional(),
  alert_suppression: _common_attributes.AlertSuppression.optional()
});
const EqlRuleCreateFields = exports.EqlRuleCreateFields = EqlRequiredFields.merge(EqlOptionalFields);
const EqlRuleResponseFields = exports.EqlRuleResponseFields = EqlRequiredFields.merge(EqlOptionalFields);
const EqlRulePatchFields = exports.EqlRulePatchFields = EqlRequiredFields.partial().merge(EqlOptionalFields);
const EqlRule = exports.EqlRule = SharedResponseProps.merge(EqlRuleResponseFields);
const EqlRuleCreateProps = exports.EqlRuleCreateProps = SharedCreateProps.merge(EqlRuleCreateFields);
const EqlRuleUpdateProps = exports.EqlRuleUpdateProps = SharedUpdateProps.merge(EqlRuleCreateFields);
const EqlRulePatchProps = exports.EqlRulePatchProps = SharedPatchProps.merge(EqlRulePatchFields);
const QueryRuleRequiredFields = exports.QueryRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('query')
});
const QueryRuleOptionalFields = exports.QueryRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  saved_id: _common_attributes.SavedQueryId.optional(),
  response_actions: _zod.z.array(_response_actions.ResponseAction).optional(),
  alert_suppression: _common_attributes.AlertSuppression.optional()
});
const QueryRuleDefaultableFields = exports.QueryRuleDefaultableFields = _zod.z.object({
  query: _common_attributes.RuleQuery.optional(),
  language: _common_attributes.KqlQueryLanguage.optional()
});
const QueryRuleCreateFields = exports.QueryRuleCreateFields = QueryRuleRequiredFields.merge(QueryRuleOptionalFields).merge(QueryRuleDefaultableFields);
const QueryRulePatchFields = exports.QueryRulePatchFields = QueryRuleRequiredFields.partial().merge(QueryRuleOptionalFields).merge(QueryRuleDefaultableFields);
const QueryRuleResponseFields = exports.QueryRuleResponseFields = QueryRuleRequiredFields.merge(QueryRuleOptionalFields).merge(QueryRuleDefaultableFields.required());
const QueryRule = exports.QueryRule = SharedResponseProps.merge(QueryRuleResponseFields);
const QueryRuleCreateProps = exports.QueryRuleCreateProps = SharedCreateProps.merge(QueryRuleCreateFields);
const QueryRuleUpdateProps = exports.QueryRuleUpdateProps = SharedUpdateProps.merge(QueryRuleCreateFields);
const QueryRulePatchProps = exports.QueryRulePatchProps = SharedPatchProps.merge(QueryRulePatchFields);
const SavedQueryRuleRequiredFields = exports.SavedQueryRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('saved_query'),
  saved_id: _common_attributes.SavedQueryId
});
const SavedQueryRuleOptionalFields = exports.SavedQueryRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  response_actions: _zod.z.array(_response_actions.ResponseAction).optional(),
  alert_suppression: _common_attributes.AlertSuppression.optional(),
  query: _common_attributes.RuleQuery.optional()
});
const SavedQueryRuleDefaultableFields = exports.SavedQueryRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
const SavedQueryRuleCreateFields = exports.SavedQueryRuleCreateFields = SavedQueryRuleRequiredFields.merge(SavedQueryRuleOptionalFields).merge(SavedQueryRuleDefaultableFields);
const SavedQueryRulePatchFields = exports.SavedQueryRulePatchFields = SavedQueryRuleRequiredFields.partial().merge(SavedQueryRuleOptionalFields).merge(SavedQueryRuleDefaultableFields);
const SavedQueryRuleResponseFields = exports.SavedQueryRuleResponseFields = SavedQueryRuleRequiredFields.merge(SavedQueryRuleOptionalFields).merge(SavedQueryRuleDefaultableFields.required());
const SavedQueryRule = exports.SavedQueryRule = SharedResponseProps.merge(SavedQueryRuleResponseFields);
const SavedQueryRuleCreateProps = exports.SavedQueryRuleCreateProps = SharedCreateProps.merge(SavedQueryRuleCreateFields);
const SavedQueryRuleUpdateProps = exports.SavedQueryRuleUpdateProps = SharedUpdateProps.merge(SavedQueryRuleCreateFields);
const SavedQueryRulePatchProps = exports.SavedQueryRulePatchProps = SharedPatchProps.merge(SavedQueryRulePatchFields);
const ThresholdRuleRequiredFields = exports.ThresholdRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('threshold'),
  query: _common_attributes.RuleQuery,
  threshold: _threshold_attributes.Threshold
});
const ThresholdRuleOptionalFields = exports.ThresholdRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  saved_id: _common_attributes.SavedQueryId.optional(),
  alert_suppression: _threshold_attributes.ThresholdAlertSuppression.optional()
});
const ThresholdRuleDefaultableFields = exports.ThresholdRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
const ThresholdRuleCreateFields = exports.ThresholdRuleCreateFields = ThresholdRuleRequiredFields.merge(ThresholdRuleOptionalFields).merge(ThresholdRuleDefaultableFields);
const ThresholdRulePatchFields = exports.ThresholdRulePatchFields = ThresholdRuleRequiredFields.partial().merge(ThresholdRuleOptionalFields).merge(ThresholdRuleDefaultableFields);
const ThresholdRuleResponseFields = exports.ThresholdRuleResponseFields = ThresholdRuleRequiredFields.merge(ThresholdRuleOptionalFields).merge(ThresholdRuleDefaultableFields.required());
const ThresholdRule = exports.ThresholdRule = SharedResponseProps.merge(ThresholdRuleResponseFields);
const ThresholdRuleCreateProps = exports.ThresholdRuleCreateProps = SharedCreateProps.merge(ThresholdRuleCreateFields);
const ThresholdRuleUpdateProps = exports.ThresholdRuleUpdateProps = SharedUpdateProps.merge(ThresholdRuleCreateFields);
const ThresholdRulePatchProps = exports.ThresholdRulePatchProps = SharedPatchProps.merge(ThresholdRulePatchFields);
const ThreatMatchRuleRequiredFields = exports.ThreatMatchRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('threat_match'),
  query: _common_attributes.RuleQuery,
  threat_query: _threat_match_attributes.ThreatQuery,
  threat_mapping: _threat_match_attributes.ThreatMapping,
  threat_index: _threat_match_attributes.ThreatIndex
});
const ThreatMatchRuleOptionalFields = exports.ThreatMatchRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  saved_id: _common_attributes.SavedQueryId.optional(),
  threat_filters: _threat_match_attributes.ThreatFilters.optional(),
  threat_indicator_path: _threat_match_attributes.ThreatIndicatorPath.optional(),
  threat_language: _common_attributes.KqlQueryLanguage.optional(),
  concurrent_searches: _threat_match_attributes.ConcurrentSearches.optional(),
  items_per_search: _threat_match_attributes.ItemsPerSearch.optional(),
  alert_suppression: _common_attributes.AlertSuppression.optional()
});
const ThreatMatchRuleDefaultableFields = exports.ThreatMatchRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
const ThreatMatchRuleCreateFields = exports.ThreatMatchRuleCreateFields = ThreatMatchRuleRequiredFields.merge(ThreatMatchRuleOptionalFields).merge(ThreatMatchRuleDefaultableFields);
const ThreatMatchRulePatchFields = exports.ThreatMatchRulePatchFields = ThreatMatchRuleRequiredFields.partial().merge(ThreatMatchRuleOptionalFields).merge(ThreatMatchRuleDefaultableFields);
const ThreatMatchRuleResponseFields = exports.ThreatMatchRuleResponseFields = ThreatMatchRuleRequiredFields.merge(ThreatMatchRuleOptionalFields).merge(ThreatMatchRuleDefaultableFields.required());
const ThreatMatchRule = exports.ThreatMatchRule = SharedResponseProps.merge(ThreatMatchRuleResponseFields);
const ThreatMatchRuleCreateProps = exports.ThreatMatchRuleCreateProps = SharedCreateProps.merge(ThreatMatchRuleCreateFields);
const ThreatMatchRuleUpdateProps = exports.ThreatMatchRuleUpdateProps = SharedUpdateProps.merge(ThreatMatchRuleCreateFields);
const ThreatMatchRulePatchProps = exports.ThreatMatchRulePatchProps = SharedPatchProps.merge(ThreatMatchRulePatchFields);
const MachineLearningRuleRequiredFields = exports.MachineLearningRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('machine_learning'),
  anomaly_threshold: _ml_attributes.AnomalyThreshold,
  machine_learning_job_id: _ml_attributes.MachineLearningJobId
});
const MachineLearningRulePatchFields = exports.MachineLearningRulePatchFields = MachineLearningRuleRequiredFields.partial();
const MachineLearningRuleResponseFields = exports.MachineLearningRuleResponseFields = MachineLearningRuleRequiredFields;
const MachineLearningRuleCreateFields = exports.MachineLearningRuleCreateFields = MachineLearningRuleRequiredFields;
const MachineLearningRule = exports.MachineLearningRule = SharedResponseProps.merge(MachineLearningRuleResponseFields);
const MachineLearningRuleCreateProps = exports.MachineLearningRuleCreateProps = SharedCreateProps.merge(MachineLearningRuleCreateFields);
const MachineLearningRuleUpdateProps = exports.MachineLearningRuleUpdateProps = SharedUpdateProps.merge(MachineLearningRuleCreateFields);
const MachineLearningRulePatchProps = exports.MachineLearningRulePatchProps = SharedPatchProps.merge(MachineLearningRulePatchFields);
const NewTermsRuleRequiredFields = exports.NewTermsRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('new_terms'),
  query: _common_attributes.RuleQuery,
  new_terms_fields: _new_terms_attributes.NewTermsFields,
  history_window_start: _new_terms_attributes.HistoryWindowStart
});
const NewTermsRuleOptionalFields = exports.NewTermsRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  alert_suppression: _common_attributes.AlertSuppression.optional()
});
const NewTermsRuleDefaultableFields = exports.NewTermsRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
const NewTermsRulePatchFields = exports.NewTermsRulePatchFields = NewTermsRuleRequiredFields.partial().merge(NewTermsRuleOptionalFields).merge(NewTermsRuleDefaultableFields);
const NewTermsRuleResponseFields = exports.NewTermsRuleResponseFields = NewTermsRuleRequiredFields.merge(NewTermsRuleOptionalFields).merge(NewTermsRuleDefaultableFields.required());
const NewTermsRuleCreateFields = exports.NewTermsRuleCreateFields = NewTermsRuleRequiredFields.merge(NewTermsRuleOptionalFields).merge(NewTermsRuleDefaultableFields);
const NewTermsRule = exports.NewTermsRule = SharedResponseProps.merge(NewTermsRuleResponseFields);
const NewTermsRuleCreateProps = exports.NewTermsRuleCreateProps = SharedCreateProps.merge(NewTermsRuleCreateFields);
const NewTermsRuleUpdateProps = exports.NewTermsRuleUpdateProps = SharedUpdateProps.merge(NewTermsRuleCreateFields);
const NewTermsRulePatchProps = exports.NewTermsRulePatchProps = SharedPatchProps.merge(NewTermsRulePatchFields);
const EsqlQueryLanguage = exports.EsqlQueryLanguage = _zod.z.literal('esql');
const EsqlRuleRequiredFields = exports.EsqlRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('esql'),
  language: EsqlQueryLanguage,
  /**
   * ESQL query to execute
   */
  query: _common_attributes.RuleQuery
});
const EsqlRulePatchFields = exports.EsqlRulePatchFields = EsqlRuleRequiredFields.partial();
const EsqlRuleResponseFields = exports.EsqlRuleResponseFields = EsqlRuleRequiredFields;
const EsqlRuleCreateFields = exports.EsqlRuleCreateFields = EsqlRuleRequiredFields;
const EsqlRule = exports.EsqlRule = SharedResponseProps.merge(EsqlRuleResponseFields);
const EsqlRuleCreateProps = exports.EsqlRuleCreateProps = SharedCreateProps.merge(EsqlRuleCreateFields);
const EsqlRuleUpdateProps = exports.EsqlRuleUpdateProps = SharedUpdateProps.merge(EsqlRuleCreateFields);
const EsqlRulePatchProps = exports.EsqlRulePatchProps = SharedPatchProps.merge(EsqlRulePatchFields.partial());
const TypeSpecificCreateProps = exports.TypeSpecificCreateProps = _zod.z.discriminatedUnion('type', [EqlRuleCreateFields, QueryRuleCreateFields, SavedQueryRuleCreateFields, ThresholdRuleCreateFields, ThreatMatchRuleCreateFields, MachineLearningRuleCreateFields, NewTermsRuleCreateFields, EsqlRuleCreateFields]);
const TypeSpecificPatchProps = exports.TypeSpecificPatchProps = _zod.z.union([EqlRulePatchFields, QueryRulePatchFields, SavedQueryRulePatchFields, ThresholdRulePatchFields, ThreatMatchRulePatchFields, MachineLearningRulePatchFields, NewTermsRulePatchFields, EsqlRulePatchFields]);
const TypeSpecificResponse = exports.TypeSpecificResponse = _zod.z.discriminatedUnion('type', [EqlRuleResponseFields, QueryRuleResponseFields, SavedQueryRuleResponseFields, ThresholdRuleResponseFields, ThreatMatchRuleResponseFields, MachineLearningRuleResponseFields, NewTermsRuleResponseFields, EsqlRuleResponseFields]);
const RuleCreateProps = exports.RuleCreateProps = _zod.z.discriminatedUnion('type', [EqlRuleCreateProps, QueryRuleCreateProps, SavedQueryRuleCreateProps, ThresholdRuleCreateProps, ThreatMatchRuleCreateProps, MachineLearningRuleCreateProps, NewTermsRuleCreateProps, EsqlRuleCreateProps]);
const RuleUpdateProps = exports.RuleUpdateProps = _zod.z.discriminatedUnion('type', [EqlRuleUpdateProps, QueryRuleUpdateProps, SavedQueryRuleUpdateProps, ThresholdRuleUpdateProps, ThreatMatchRuleUpdateProps, MachineLearningRuleUpdateProps, NewTermsRuleUpdateProps, EsqlRuleUpdateProps]);
const RulePatchProps = exports.RulePatchProps = _zod.z.union([EqlRulePatchProps, QueryRulePatchProps, SavedQueryRulePatchProps, ThresholdRulePatchProps, ThreatMatchRulePatchProps, MachineLearningRulePatchProps, NewTermsRulePatchProps, EsqlRulePatchProps]);
const RuleResponse = exports.RuleResponse = _zod.z.discriminatedUnion('type', [EqlRule, QueryRule, SavedQueryRule, ThresholdRule, ThreatMatchRule, MachineLearningRule, NewTermsRule, EsqlRule]);