"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksImageCards = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _links = require("../links");
var _beta_badge = require("./beta_badge");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CARD_WIDTH = 320;
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      max-width: ${CARD_WIDTH}px;
    `,
    card: (0, _react2.css)`
      // Needed to use the primary color in the title underlining on hover
      .euiCard__title {
        color: ${euiTheme.colors.primaryText};
      }
    `,
    titleContainer: (0, _react2.css)`
      display: flex;
      align-items: center;
    `,
    title: (0, _react2.css)`
      color: ${euiTheme.colors.primaryText};
    `,
    description: (0, _react2.css)`
      padding-top: ${euiTheme.size.xs};
      max-width: 550px;
    `
  };
};
const EuiCardWithLink = (0, _links.withLink)(_eui.EuiCard);
const LandingLinksImageCards = exports.LandingLinksImageCards = /*#__PURE__*/_react.default.memo(function LandingLinksImageCards({
  items,
  urlState,
  onLinkClick
}) {
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    wrap: true,
    "data-test-subj": "LandingImageCards"
  }, items.map(item => {
    const linkProps = (0, _utils.getKibanaLinkProps)({
      item,
      urlState,
      onLinkClick
    });
    const {
      id,
      landingImage,
      title,
      description,
      isBeta,
      betaOptions
    } = item;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id,
      "data-test-subj": "LandingImageCard-item",
      grow: false,
      css: styles.container
    }, /*#__PURE__*/_react.default.createElement(EuiCardWithLink, (0, _extends2.default)({}, linkProps, {
      hasBorder: true,
      textAlign: "left",
      paddingSize: "m",
      css: styles.card,
      image: landingImage && /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        "data-test-subj": "LandingImageCard-image",
        role: "presentation",
        size: CARD_WIDTH,
        alt: title,
        src: landingImage
      }),
      title: /*#__PURE__*/_react.default.createElement("div", {
        css: styles.titleContainer
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        css: styles.title
      }, /*#__PURE__*/_react.default.createElement("h2", null, title)), isBeta && /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
        text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text
      })),
      titleElement: "span",
      description: /*#__PURE__*/_react.default.createElement("span", {
        css: styles.description
      }, description)
    })));
  }));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LandingLinksImageCards;