"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksImages = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _links = require("../links");
var _beta_badge = require("./beta_badge");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noop = () => {};
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    link: (0, _react2.css)`
      color: inherit;
      &:hover {
        text-decoration: none;
      }
    `,
    image: (0, _react2.css)`
      align-items: center;
    `,
    content: (0, _react2.css)`
      padding-left: ${euiTheme.size.s};
    `,
    titleContainer: (0, _react2.css)`
      display: flex;
      align-items: center;
    `,
    title: (0, _react2.css)`
      color: ${euiTheme.colors.primaryText};
      align-items: center;
    `,
    description: (0, _react2.css)`
      padding-top: ${euiTheme.size.xs};
      max-width: 550px;
    `
  };
};
const LandingLinksImages = exports.LandingLinksImages = /*#__PURE__*/_react.default.memo(function LandingLinksImages({
  items,
  urlState,
  onLinkClick
}) {
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, items.map(item => {
    const linkProps = (0, _utils.getKibanaLinkProps)({
      item,
      urlState,
      onLinkClick
    });
    const {
      id,
      title,
      description,
      landingImage,
      isBeta,
      betaOptions
    } = item;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id,
      "data-test-subj": "LandingItem"
    }, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, (0, _extends2.default)({}, linkProps, {
      tabIndex: -1,
      css: styles.link
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      paddingSize: "m",
      onClick: noop
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: styles.image
    }, landingImage && /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      "data-test-subj": "LandingLinksImage",
      size: "l",
      role: "presentation",
      alt: "",
      src: landingImage
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.content
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: styles.titleContainer
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      css: styles.title
    }, /*#__PURE__*/_react.default.createElement("h2", null, title)), isBeta && /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
      text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: styles.description
    }, description))))));
  }));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LandingLinksImages;