"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_UI_APP_ID = exports.LinkCategoryType = exports.ExternalPageName = void 0;
Object.defineProperty(exports, "SecurityPageName", {
  enumerable: true,
  get: function () {
    return _deeplinksSecurity.SecurityPageName;
  }
});
var _deeplinksSecurity = require("@kbn/deeplinks-security");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_UI_APP_ID = exports.SECURITY_UI_APP_ID = 'securitySolutionUI';
let LinkCategoryType = exports.LinkCategoryType = /*#__PURE__*/function (LinkCategoryType) {
  LinkCategoryType["title"] = "title";
  LinkCategoryType["collapsibleTitle"] = "collapsibleTitle";
  LinkCategoryType["accordion"] = "accordion";
  LinkCategoryType["separator"] = "separator";
  return LinkCategoryType;
}({});
/**
 * External (non-Security) page names that need to be linked in the Security navigation.
 * Format: `<pluginId>:<deepLinkId>/<path>`.
 *
 * `pluginId`: is the id of the plugin that owns the deep link
 *
 * `deepLinkId`: is the id of the deep link inside the plugin.
 * Keep empty for the root page of the plugin, e.g. `osquery:`
 *
 * `path`: is the path to append to the plugin and deep link.
 * This is optional and only needed if the path is not registered in the plugin's `deepLinks`. e.g. `integrations:/browse/security`
 * The path should not be used for links displayed in the main left navigation, since highlighting won't work.
 **/
let ExternalPageName = exports.ExternalPageName = /*#__PURE__*/function (ExternalPageName) {
  ExternalPageName["discover"] = "discover:";
  ExternalPageName["osquery"] = "osquery:";
  ExternalPageName["maps"] = "maps:";
  ExternalPageName["visualize"] = "visualize:";
  ExternalPageName["mlOverview"] = "ml:overview";
  ExternalPageName["mlNotifications"] = "ml:notifications";
  ExternalPageName["mlMemoryUsage"] = "ml:memoryUsage";
  ExternalPageName["mlAnomalyDetection"] = "ml:anomalyDetection";
  ExternalPageName["mlAnomalyExplorer"] = "ml:anomalyExplorer";
  ExternalPageName["mlSingleMetricViewer"] = "ml:singleMetricViewer";
  ExternalPageName["mlSettings"] = "ml:settings";
  ExternalPageName["mlDataFrameAnalytics"] = "ml:dataFrameAnalytics";
  ExternalPageName["mlResultExplorer"] = "ml:resultExplorer";
  ExternalPageName["mlAnalyticsMap"] = "ml:analyticsMap";
  ExternalPageName["mlNodesOverview"] = "ml:nodesOverview";
  ExternalPageName["mlNodes"] = "ml:nodes";
  ExternalPageName["mlFileUpload"] = "ml:fileUpload";
  ExternalPageName["mlIndexDataVisualizer"] = "ml:indexDataVisualizer";
  ExternalPageName["mlDataDrift"] = "ml:dataDrift";
  ExternalPageName["mlExplainLogRateSpikes"] = "ml:logRateAnalysis";
  ExternalPageName["mlLogPatternAnalysis"] = "ml:logPatternAnalysis";
  ExternalPageName["mlChangePointDetections"] = "ml:changePointDetections";
  ExternalPageName["devTools"] = "dev_tools:";
  ExternalPageName["fleet"] = "fleet:";
  ExternalPageName["fleetAgents"] = "fleet:agents";
  ExternalPageName["fleetPolicies"] = "fleet:policies";
  ExternalPageName["fleetEnrollmentTokens"] = "fleet:enrollment_tokens";
  ExternalPageName["fleetUninstallTokens"] = "fleet:uninstall_tokens";
  ExternalPageName["fleetDataStreams"] = "fleet:data_streams";
  ExternalPageName["fleetSettings"] = "fleet:settings";
  ExternalPageName["integrationsSecurity"] = "integrations:/browse/security";
  ExternalPageName["management"] = "management:";
  ExternalPageName["managementIngestPipelines"] = "management:ingest_pipelines";
  ExternalPageName["managementPipelines"] = "management:pipelines";
  ExternalPageName["managementIndexManagement"] = "management:index_management";
  ExternalPageName["managementTransforms"] = "management:transform";
  ExternalPageName["managementMaintenanceWindows"] = "management:maintenanceWindows";
  ExternalPageName["managementTriggersActions"] = "management:triggersActions";
  ExternalPageName["managementCases"] = "management:cases";
  ExternalPageName["managementTriggersActionsConnectors"] = "management:triggersActionsConnectors";
  ExternalPageName["managementReporting"] = "management:reporting";
  ExternalPageName["managementJobsListLink"] = "management:jobsListLink";
  ExternalPageName["managementDataViews"] = "management:dataViews";
  ExternalPageName["managementObjects"] = "management:objects";
  ExternalPageName["managementApiKeys"] = "management:api_keys";
  ExternalPageName["managementTags"] = "management:tags";
  ExternalPageName["managementFiles"] = "management:filesManagement";
  ExternalPageName["managementSpaces"] = "management:spaces";
  ExternalPageName["managementSettings"] = "management:settings";
  ExternalPageName["cloudUsersAndRoles"] = "cloud:usersAndRoles";
  ExternalPageName["cloudBilling"] = "cloud:billing";
  ExternalPageName["cloudPerformance"] = "cloud:performance";
  return ExternalPageName;
}({});