"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securitySubFeaturesMap = exports.getSecurityBaseKibanaSubFeatureIds = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _product_features_privileges = require("../product_features_privileges");
var _product_features_keys = require("../product_features_keys");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endpointListSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint List access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList', {
    defaultMessage: 'Endpoint List'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList.description', {
    defaultMessage: 'Displays all hosts running Elastic Defend and their relevant integration details.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeEndpointList`, `${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeEndpointList', 'readEndpointList']
    }, {
      api: [`${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEndpointList']
    }]
  }]
};
const trustedApplicationsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Trusted Applications access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications', {
    defaultMessage: 'Trusted Applications'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications.description', {
    defaultMessage: 'Helps mitigate conflicts with other software, usually other antivirus or endpoint security applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeTrustedApplications`, `${_constants.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeTrustedApplications', 'readTrustedApplications']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readTrustedApplications']
    }]
  }]
};
const hostIsolationExceptionsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation Exceptions access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions', {
    defaultMessage: 'Host Isolation Exceptions'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions.description', {
    defaultMessage: 'Add specific IP addresses that isolated hosts are still allowed to communicate with, even when isolated from the rest of the network.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-deleteHostIsolationExceptions`, `${_constants.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['readHostIsolationExceptions', 'deleteHostIsolationExceptions']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readHostIsolationExceptions']
    }]
  }]
};
const blocklistSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Blocklist access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList', {
    defaultMessage: 'Blocklist'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList.description', {
    defaultMessage: 'Extend Elastic Defend’s protection against malicious processes and protect against potentially harmful applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeBlocklist`, `${_constants.APP_ID}-readBlocklist`],
      id: 'blocklist_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeBlocklist', 'readBlocklist']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readBlocklist`],
      id: 'blocklist_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readBlocklist']
    }]
  }]
};
const eventFiltersSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Event Filters access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters', {
    defaultMessage: 'Event Filters'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters.description', {
    defaultMessage: 'Filter out endpoint events that you do not need or want stored in Elasticsearch.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeEventFilters`, `${_constants.APP_ID}-readEventFilters`],
      id: 'event_filters_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeEventFilters', 'readEventFilters']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readEventFilters`],
      id: 'event_filters_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEventFilters']
    }]
  }]
};
const policyManagementSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Policy Management access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement', {
    defaultMessage: 'Elastic Defend Policy Management'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement.description', {
    defaultMessage: 'Access the Elastic Defend integration policy to configure protections, event collection, and advanced policy features.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writePolicyManagement`, `${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: ['policy-settings-protection-updates-note'],
        read: []
      },
      ui: ['writePolicyManagement', 'readPolicyManagement']
    }, {
      api: [`${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: ['policy-settings-protection-updates-note']
      },
      ui: ['readPolicyManagement']
    }]
  }]
};
const responseActionsHistorySubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Response Actions History access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory', {
    defaultMessage: 'Response Actions History'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory.description', {
    defaultMessage: 'Access the history of response actions performed on endpoints.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeActionsLogManagement`, `${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeActionsLogManagement', 'readActionsLogManagement']
    }, {
      api: [`${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_read',
      includeIn: 'none',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readActionsLogManagement']
    }]
  }]
};
const hostIsolationSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation', {
    defaultMessage: 'Host Isolation'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation.description', {
    defaultMessage: 'Perform the "isolate" and "release" response actions.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeHostIsolationRelease`],
      id: 'host_isolation_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeHostIsolationRelease']
    }]
  }]
};
const processOperationsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Process Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations', {
    defaultMessage: 'Process Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations.description', {
    defaultMessage: 'Perform process-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeProcessOperations`],
      id: 'process_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeProcessOperations']
    }]
  }]
};
const fileOperationsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for File Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations', {
    defaultMessage: 'File Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations.description', {
    defaultMessage: 'Perform file-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeFileOperations`],
      id: 'file_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeFileOperations']
    }]
  }]
};

// execute operations are not available in 8.7,
// but will be available in 8.8
const executeActionSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Execute Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations', {
    defaultMessage: 'Execute Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations.description', {
    defaultMessage: 'Perform script execution response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeExecuteOperations`],
      id: 'execute_operations_all',
      includeIn: 'none',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeExecuteOperations']
    }]
  }]
};
const endpointExceptionsSubFeature = {
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint Exceptions access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions', {
    defaultMessage: 'Endpoint Exceptions'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions.description', {
    defaultMessage: 'Use Endpoint Exceptions (this is a test sub-feature).'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      id: 'endpoint_exceptions_all',
      includeIn: 'all',
      name: 'All',
      savedObject: {
        all: [],
        read: []
      },
      ..._product_features_privileges.ProductFeaturesPrivileges[_product_features_privileges.ProductFeaturesPrivilegeId.endpointExceptions].all
    }, {
      id: 'endpoint_exceptions_read',
      includeIn: 'read',
      name: 'Read',
      savedObject: {
        all: [],
        read: []
      },
      ..._product_features_privileges.ProductFeaturesPrivileges[_product_features_privileges.ProductFeaturesPrivilegeId.endpointExceptions].read
    }]
  }]
};

/**
 * Sub-features that will always be available for Security
 * regardless of the product type.
 */
const getSecurityBaseKibanaSubFeatureIds = ({
  experimentalFeatures
}) => [_product_features_keys.SecuritySubFeatureId.hostIsolation];

/**
 * Defines all the Security Assistant subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getSecurityBaseKibanaSubFeatureIds = getSecurityBaseKibanaSubFeatureIds;
const securitySubFeaturesMap = exports.securitySubFeaturesMap = Object.freeze(new Map([[_product_features_keys.SecuritySubFeatureId.endpointList, endpointListSubFeature], [_product_features_keys.SecuritySubFeatureId.endpointExceptions, endpointExceptionsSubFeature], [_product_features_keys.SecuritySubFeatureId.trustedApplications, trustedApplicationsSubFeature], [_product_features_keys.SecuritySubFeatureId.hostIsolationExceptions, hostIsolationExceptionsSubFeature], [_product_features_keys.SecuritySubFeatureId.blocklist, blocklistSubFeature], [_product_features_keys.SecuritySubFeatureId.eventFilters, eventFiltersSubFeature], [_product_features_keys.SecuritySubFeatureId.policyManagement, policyManagementSubFeature], [_product_features_keys.SecuritySubFeatureId.responseActionsHistory, responseActionsHistorySubFeature], [_product_features_keys.SecuritySubFeatureId.hostIsolation, hostIsolationSubFeature], [_product_features_keys.SecuritySubFeatureId.processOperations, processOperationsSubFeature], [_product_features_keys.SecuritySubFeatureId.fileOperations, fileOperationsSubFeature], [_product_features_keys.SecuritySubFeatureId.executeAction, executeActionSubFeature]]));