"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsellingSections = exports.upsellingPages = exports.upsellingMessages = exports.registerUpsellings = void 0;
var _common = require("@kbn/security-solution-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _messages = require("@kbn/security-solution-upselling/messages");
var _services = require("../common/services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EntityAnalyticsUpsellingLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/security-solution-upselling/pages/entity_analytics'))));
const registerUpsellings = (upselling, license, services) => {
  const upsellingPagesToRegister = upsellingPages(services).reduce((pageUpsellings, {
    pageName,
    minimumLicenseRequired,
    component
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      pageUpsellings[pageName] = (0, _services.withServicesProvider)(component, services);
    }
    return pageUpsellings;
  }, {});
  const upsellingSectionsToRegister = upsellingSections.reduce((sectionUpsellings, {
    id,
    minimumLicenseRequired,
    component
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      sectionUpsellings[id] = component;
    }
    return sectionUpsellings;
  }, {});
  const upsellingMessagesToRegister = upsellingMessages.reduce((messagesUpsellings, {
    id,
    minimumLicenseRequired,
    message
  }) => {
    if (!license.hasAtLeast(minimumLicenseRequired)) {
      messagesUpsellings[id] = message;
    }
    return messagesUpsellings;
  }, {});
  upselling.setPages(upsellingPagesToRegister);
  upselling.setSections(upsellingSectionsToRegister);
  upselling.setMessages(upsellingMessagesToRegister);
};

// Upsellings for entire pages, linked to a SecurityPageName
exports.registerUpsellings = registerUpsellings;
const upsellingPages = services => [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  pageName: _common.SecurityPageName.entityAnalytics,
  minimumLicenseRequired: 'platinum',
  component: () => /*#__PURE__*/_react.default.createElement(EntityAnalyticsUpsellingLazy, {
    requiredLicense: "Platinum",
    subscriptionUrl: services.application.getUrlForApp('management', {
      path: 'stack/license_management'
    })
  })
}];

// Upsellings for sections, linked by arbitrary ids
exports.upsellingPages = upsellingPages;
const upsellingSections = exports.upsellingSections = [
  // It is highly advisable to make use of lazy loaded components to minimize bundle size.
];

// Upsellings for sections, linked by arbitrary ids
const upsellingMessages = exports.upsellingMessages = [{
  id: 'investigation_guide',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.UPGRADE_INVESTIGATION_GUIDE)('Platinum')
}, {
  id: 'alert_assignments',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.UPGRADE_ALERT_ASSIGNMENTS)('Platinum')
}, {
  id: 'alert_suppression_rule_form',
  minimumLicenseRequired: 'platinum',
  message: (0, _messages.ALERT_SUPPRESSION_RULE_FORM)('Platinum')
}, {
  id: 'alert_suppression_rule_details',
  minimumLicenseRequired: 'platinum',
  message: _messages.ALERT_SUPPRESSION_RULE_DETAILS
}];