"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionEssPlugin = void 0;
var _navigation = require("./navigation");
var _services = require("./common/services");
var _register_upsellings = require("./upselling/register_upsellings");
var _onboarding = require("./onboarding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuritySolutionEssPlugin {
  setup(_core, _setupDeps) {
    return {};
  }
  start(core, startDeps) {
    const {
      securitySolution,
      licensing
    } = startDeps;
    const services = (0, _services.createServices)(core, startDeps);
    (0, _navigation.startNavigation)(services);
    (0, _onboarding.setOnboardingSettings)(services);
    licensing.license$.subscribe(license => {
      (0, _register_upsellings.registerUpsellings)(securitySolution.getUpselling(), license, services);
    });
    return {};
  }
  stop() {}
}
exports.SecuritySolutionEssPlugin = SecuritySolutionEssPlugin;