"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initSideNavigation = exports.SOLUTION_NAME = void 0;
var _rxjs = require("rxjs");
var _immer = _interopRequireDefault(require("immer"));
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = exports.SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolutionEss.nav.solutionName', {
  defaultMessage: 'Security'
});
const initSideNavigation = async services => {
  const {
    securitySolution,
    navigation
  } = services;
  navigation.isSolutionNavEnabled$.subscribe(isSolutionNavigationEnabled => {
    securitySolution.setIsSolutionNavigationEnabled(isSolutionNavigationEnabled);
  });
  const {
    navigationTree$,
    panelContentProvider
  } = await securitySolution.getSolutionNavigation();
  const essNavigationTree$ = navigationTree$.pipe((0, _rxjs.map)(navigationTree => (0, _immer.default)(navigationTree, draft => {
    var _draft$footer;
    const footerGroup = (_draft$footer = draft.footer) === null || _draft$footer === void 0 ? void 0 : _draft$footer.find(({
      type
    }) => type === 'navGroup');
    const management = footerGroup === null || footerGroup === void 0 ? void 0 : footerGroup.children.find(child => child.link === 'management');
    if (management) {
      management.renderAs = 'panelOpener';
      management.id = 'stack_management';
      management.spaceBefore = null;
      management.children = stackManagementLinks;
    }
  })));
  navigation.addSolutionNavigation({
    id: 'security',
    homePage: `${_securitySolutionNavigation.SECURITY_UI_APP_ID}:${_securitySolutionNavigation.SecurityPageName.landing}`,
    title: SOLUTION_NAME,
    icon: 'logoSecurity',
    navigationTree$: essNavigationTree$,
    panelContentProvider,
    dataTestSubj: 'securitySolutionSideNav'
  });
};

// Temporary configuration to render the stack management links in the panel
exports.initSideNavigation = initSideNavigation;
const stackManagementLinks = [{
  title: 'Ingest',
  children: [{
    link: 'management:ingest_pipelines'
  }, {
    link: 'management:pipelines'
  }]
}, {
  title: 'Data',
  children: [{
    link: 'management:index_management'
  }, {
    link: 'management:index_lifecycle_management'
  }, {
    link: 'management:snapshot_restore'
  }, {
    link: 'management:rollup_jobs'
  }, {
    link: 'management:transform'
  }, {
    link: 'management:cross_cluster_replication'
  }, {
    link: 'management:remote_clusters'
  }, {
    link: 'management:migrate_data'
  }]
}, {
  title: 'Alerts and Insights',
  children: [{
    link: 'management:triggersActions'
  }, {
    link: 'management:cases'
  }, {
    link: 'management:triggersActionsConnectors'
  }, {
    link: 'management:reporting'
  }, {
    link: 'management:jobsListLink'
  }, {
    link: 'management:watcher'
  }, {
    link: 'management:maintenanceWindows'
  }]
}, {
  title: 'Security',
  children: [{
    link: 'management:users'
  }, {
    link: 'management:roles'
  }, {
    link: 'management:api_keys'
  }, {
    link: 'management:role_mappings'
  }]
}, {
  title: 'Kibana',
  children: [{
    link: 'management:dataViews'
  }, {
    link: 'management:filesManagement'
  }, {
    link: 'management:objects'
  }, {
    link: 'management:tags'
  }, {
    link: 'management:search_sessions'
  }, {
    link: 'management:aiAssistantManagementSelection'
  }, {
    link: 'management:spaces'
  }, {
    link: 'management:settings'
  }]
}, {
  title: 'Stack',
  children: [{
    link: 'management:license_management'
  }, {
    link: 'management:upgrade_assistant'
  }]
}];