"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersManagementApp = exports.Providers = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _use_current_user = require("../../components/use_current_user");
var _readonly_badge = require("../badges/readonly_badge");
var _url_utils = require("../url_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const usersManagementApp = exports.usersManagementApp = Object.freeze({
  id: 'users',
  create({
    authc,
    getStartServices
  }) {
    const title = _i18n.i18n.translate('xpack.security.management.usersTitle', {
      defaultMessage: 'Users'
    });
    return {
      id: this.id,
      order: 10,
      title,
      async mount({
        element,
        theme$,
        setBreadcrumbs,
        history
      }) {
        const [[coreStart], {
          UsersGridPage
        }, {
          CreateUserPage,
          EditUserPage
        }, {
          UserAPIClient
        }, {
          RolesAPIClient
        }] = await Promise.all([getStartServices(), // TODO: remove this and write test.
        Promise.resolve().then(() => _interopRequireWildcard(require('./users_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_user'))), Promise.resolve().then(() => _interopRequireWildcard(require('./user_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('../roles')))]);
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(Providers, {
          services: coreStart,
          theme$: theme$,
          history: history,
          authc: authc,
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(coreStart.chrome, setBreadcrumbs)
        }, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
          featureId: "users",
          tooltip: _i18n.i18n.translate('xpack.security.management.users.readonlyTooltip', {
            defaultMessage: 'Unable to create or edit users'
          })
        }), /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: _i18n.i18n.translate('xpack.security.users.breadcrumb', {
            defaultMessage: 'Users'
          }),
          href: "/"
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['/', ''],
          exact: true
        }, /*#__PURE__*/_react.default.createElement(UsersGridPage, {
          notifications: coreStart.notifications,
          userAPIClient: new UserAPIClient(coreStart.http),
          rolesAPIClient: new RolesAPIClient(coreStart.http),
          history: history,
          navigateToApp: coreStart.application.navigateToApp,
          readOnly: !coreStart.application.capabilities.users.save
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/create"
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: _i18n.i18n.translate('xpack.security.users.editUserPage.createBreadcrumb', {
            defaultMessage: 'Create'
          }),
          href: "/create"
        }, /*#__PURE__*/_react.default.createElement(CreateUserPage, null))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:username",
          render: props => {
            // Additional decoding is a workaround for a bug in react-router's version of the `history` module.
            // See https://github.com/elastic/kibana/issues/82440
            const username = (0, _url_utils.tryDecodeURIComponent)(props.match.params.username);
            return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
              text: username,
              href: `/edit/${encodeURIComponent(username)}`
            }, /*#__PURE__*/_react.default.createElement(EditUserPage, {
              username: username
            }));
          }
        }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit"
        }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: "/create"
        }))))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});
const Providers = ({
  services,
  theme$,
  history,
  authc,
  onChange,
  children
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_use_current_user.AuthenticationProvider, {
  authc: authc
}, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
  theme$: theme$
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: history
}, /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
  onChange: onChange
}, children))))));
exports.Providers = Providers;