"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimplePrivilegeSection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _unsupported_space_privileges_warning = require("./unsupported_space_privileges_warning");
var _model = require("../../../../../../../common/model");
var _privilege_utils = require("../../../privilege_utils");
var _constants = require("../constants");
var _feature_table = require("../feature_table");
var _privilege_form_calculator = require("../privilege_form_calculator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SimplePrivilegeSection extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getDisplayedBasePrivilege", () => {
      if (this.state.isCustomizingGlobalPrivilege) {
        return _constants.CUSTOM_PRIVILEGE_VALUE;
      }
      const {
        role
      } = this.props;
      const form = this.locateGlobalPrivilege(role);
      return form && form.base.length > 0 ? form.base[0] : _constants.NO_PRIVILEGE_VALUE;
    });
    (0, _defineProperty2.default)(this, "onKibanaPrivilegeChange", privilege => {
      const role = (0, _model.copyRole)(this.props.role);
      const form = this.locateGlobalPrivilege(role) || this.createGlobalPrivilegeEntry(role);
      if (privilege === _constants.NO_PRIVILEGE_VALUE) {
        // Remove global entry if no privilege value
        role.kibana = role.kibana.filter(entry => !(0, _privilege_utils.isGlobalPrivilegeDefinition)(entry));
      } else if (privilege === _constants.CUSTOM_PRIVILEGE_VALUE) {
        // Remove base privilege if customizing feature privileges
        form.base = [];
      } else {
        form.base = [privilege];
        form.feature = {};
      }
      this.props.onChange(role);
      this.setState({
        isCustomizingGlobalPrivilege: privilege === _constants.CUSTOM_PRIVILEGE_VALUE,
        globalPrivsIndex: role.kibana.indexOf(form)
      });
    });
    (0, _defineProperty2.default)(this, "onFeaturePrivilegeChange", (featureId, privileges) => {
      const role = (0, _model.copyRole)(this.props.role);
      const form = this.locateGlobalPrivilege(role) || this.createGlobalPrivilegeEntry(role);
      if (privileges.length > 0) {
        form.feature[featureId] = [...privileges];
      } else {
        delete form.feature[featureId];
      }
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onChangeAllFeaturePrivileges", privileges => {
      const role = (0, _model.copyRole)(this.props.role);
      const form = this.locateGlobalPrivilege(role) || this.createGlobalPrivilegeEntry(role);
      if (privileges.length > 0) {
        this.props.kibanaPrivileges.getSecuredFeatures().forEach(feature => {
          form.feature[feature.id] = [...privileges];
        });
      } else {
        form.feature = {};
      }
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "maybeRenderSpacePrivilegeWarning", () => {
      const kibanaPrivileges = this.props.role.kibana;
      const hasSpacePrivileges = kibanaPrivileges.some(privilege => !(0, _privilege_utils.isGlobalPrivilegeDefinition)(privilege));
      if (hasSpacePrivileges) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_unsupported_space_privileges_warning.UnsupportedSpacePrivilegesWarning, null));
      }
      return null;
    });
    (0, _defineProperty2.default)(this, "locateGlobalPrivilegeIndex", role => {
      return role.kibana.findIndex(privileges => (0, _privilege_utils.isGlobalPrivilegeDefinition)(privileges));
    });
    (0, _defineProperty2.default)(this, "locateGlobalPrivilege", role => {
      const spacePrivileges = role.kibana;
      return spacePrivileges.find(privileges => (0, _privilege_utils.isGlobalPrivilegeDefinition)(privileges));
    });
    const globalPrivs = this.locateGlobalPrivilege(props.role);
    const globalPrivsIndex = this.locateGlobalPrivilegeIndex(props.role);
    this.state = {
      isCustomizingGlobalPrivilege: Boolean(globalPrivs && Object.keys(globalPrivs.feature).length > 0),
      globalPrivsIndex
    };
  }
  render() {
    var _this$props$role$kiba, _this$props$role$kiba2;
    const kibanaPrivilege = this.getDisplayedBasePrivilege();
    const reservedPrivileges = (_this$props$role$kiba = (_this$props$role$kiba2 = this.props.role.kibana[this.state.globalPrivsIndex]) === null || _this$props$role$kiba2 === void 0 ? void 0 : _this$props$role$kiba2._reserved) !== null && _this$props$role$kiba !== void 0 ? _this$props$role$kiba : [];
    const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.simplePrivilegeForm.kibanaPrivilegesTitle",
      defaultMessage: "Kibana privileges"
    });
    const description = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.simplePrivilegeForm.specifyPrivilegeForRoleDescription",
      defaultMessage: "Specifies the Kibana privilege for this role."
    }));
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: title
    }, reservedPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      selectedOptions: reservedPrivileges.map(rp => ({
        label: rp
      })),
      isDisabled: true
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      disabled: !this.props.editable,
      onChange: this.onKibanaPrivilegeChange,
      options: [{
        value: _constants.NO_PRIVILEGE_VALUE,
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.noPrivilegeInput",
          defaultMessage: "None"
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.noPrivilegeDropdown",
          defaultMessage: "None"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.noPrivilegeDropdownDescription",
          defaultMessage: "No access to Kibana"
        }))))
      }, {
        value: 'read',
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.readPrivilegeInput",
          defaultMessage: "Read"
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.readPrivilegeDropdown",
          defaultMessage: "Read"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.readPrivilegeDropdownDescription",
          defaultMessage: "Grants read-only access to all of Kibana"
        }))))
      }, {
        value: 'all',
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.allPrivilegeInput",
          defaultMessage: "All"
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.allPrivilegeDropdown",
          defaultMessage: "All"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.allPrivilegeDropdownDescription",
          defaultMessage: "Grants full access to all of Kibana"
        }))))
      }, {
        value: _constants.CUSTOM_PRIVILEGE_VALUE,
        inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.customPrivilegeInput",
          defaultMessage: "Custom"
        }),
        dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.customPrivilegeDropdown",
          defaultMessage: "Custom"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.simplePrivilegeForm.customPrivilegeDropdownDescription",
          defaultMessage: "Customize access to Kibana"
        }))))
      }],
      hasDividers: true,
      valueOfSelected: kibanaPrivilege
    })), this.state.isCustomizingGlobalPrivilege && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_feature_table.FeatureTable, {
      role: this.props.role,
      kibanaPrivileges: this.props.kibanaPrivileges,
      privilegeCalculator: new _privilege_form_calculator.PrivilegeFormCalculator(this.props.kibanaPrivileges, this.props.role),
      onChange: this.onFeaturePrivilegeChange,
      onChangeAll: this.onChangeAllFeaturePrivileges,
      privilegeIndex: this.props.role.kibana.findIndex(k => (0, _privilege_utils.isGlobalPrivilegeDefinition)(k)),
      canCustomizeSubFeaturePrivileges: this.props.canCustomizeSubFeaturePrivileges,
      allSpacesSelected: true,
      disabled: !this.props.editable
    })), this.maybeRenderSpacePrivilegeWarning())));
  }
  createGlobalPrivilegeEntry(role) {
    const newEntry = {
      spaces: ['*'],
      base: [],
      feature: {}
    };
    role.kibana.push(newEntry);
    return newEntry;
  }
}
exports.SimplePrivilegeSection = SimplePrivilegeSection;