"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureTableExpandedRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sub_feature_form = require("./sub_feature_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FeatureTableExpandedRow = ({
  feature,
  onChange,
  privilegeIndex,
  privilegeCalculator,
  selectedFeaturePrivileges,
  allSpacesSelected,
  disabled,
  licenseAllowsSubFeatPrivCustomization
}) => {
  const [isCustomizing, setIsCustomizing] = (0, _react.useState)(() => {
    return licenseAllowsSubFeatPrivCustomization && feature.getMinimalFeaturePrivileges().some(p => selectedFeaturePrivileges.includes(p.id));
  });
  (0, _react.useEffect)(() => {
    const hasMinimalFeaturePrivilegeSelected = feature.getMinimalFeaturePrivileges().some(p => selectedFeaturePrivileges.includes(p.id));
    if ((!licenseAllowsSubFeatPrivCustomization || !hasMinimalFeaturePrivilegeSelected) && isCustomizing) {
      setIsCustomizing(false);
    }
  }, [feature, isCustomizing, selectedFeaturePrivileges, licenseAllowsSubFeatPrivCustomization]);
  const onCustomizeSubFeatureChange = e => {
    onChange(feature.id, privilegeCalculator.updateSelectedFeaturePrivilegesForCustomization(feature.id, privilegeIndex, e.target.checked, allSpacesSelected));
    setIsCustomizing(e.target.checked);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.featureTable.customizeSubFeaturePrivilegesSwitchLabel",
      defaultMessage: "Customize sub-feature privileges"
    }),
    checked: isCustomizing,
    onChange: onCustomizeSubFeatureChange,
    "data-test-subj": "customizeSubFeaturePrivileges",
    disabled: disabled || !licenseAllowsSubFeatPrivCustomization || !privilegeCalculator.canCustomizeSubFeaturePrivileges(feature.id, privilegeIndex)
  }), licenseAllowsSubFeatPrivCustomization ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "data-test-subj": "subFeaturesTip",
    position: "right",
    "aria-label": "sub-feature-information-tip",
    size: "m",
    type: "iInCircle",
    color: "subdued",
    iconProps: {
      className: 'eui-alignTop'
    },
    content: _i18n.i18n.translate('xpack.security.management.editRole.featureTable.cannotCustomizeSubFeaturesTooltip', {
      defaultMessage: 'Customization of sub-feature privileges is a subscription feature.'
    })
  }))), feature.getSubFeatures().map(subFeature => {
    const isDisabledDueToSpaceSelection = subFeature.requireAllSpaces && !allSpacesSelected;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: subFeature.name
    }, /*#__PURE__*/_react.default.createElement(_sub_feature_form.SubFeatureForm, {
      privilegeCalculator: privilegeCalculator,
      privilegeIndex: privilegeIndex,
      featureId: feature.id,
      subFeature: subFeature,
      onChange: updatedPrivileges => onChange(feature.id, updatedPrivileges),
      selectedFeaturePrivileges: selectedFeaturePrivileges,
      disabled: disabled || !isCustomizing || isDisabledDueToSpaceSelection
    }));
  }));
};
exports.FeatureTableExpandedRow = FeatureTableExpandedRow;