"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./feature_table.scss");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _change_all_privileges = require("./change_all_privileges");
var _feature_table_expanded_row = require("./feature_table_expanded_row");
var _constants = require("../constants");
var _feature_table_cell = require("../feature_table_cell");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FeatureTable extends _react.Component {
  constructor(props) {
    super(props);

    // features are static for the lifetime of the page, so this is safe to do here in a non-reactive manner
    (0, _defineProperty2.default)(this, "featureCategories", new Map());
    (0, _defineProperty2.default)(this, "renderPrivilegeControlsForFeature", feature => {
      var _this$props$disabled;
      const renderFeatureMarkup = (buttonContent, extraAction, infoIcon) => {
        var _this$props$role$kiba;
        const hasSubFeaturePrivileges = feature.getSubFeaturePrivileges().length > 0;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, infoIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          className: "eui-fullWidth"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
          id: `featurePrivilegeControls_${feature.id}`,
          "data-test-subj": "featurePrivilegeControls",
          buttonContent: buttonContent,
          buttonClassName: "euiAccordionWithDescription",
          extraAction: extraAction,
          forceState: hasSubFeaturePrivileges ? undefined : 'closed',
          arrowDisplay: hasSubFeaturePrivileges ? 'left' : 'none',
          onToggle: isOpen => {
            if (isOpen) {
              this.state.expandedPrivilegeControls.add(feature.id);
            } else {
              this.state.expandedPrivilegeControls.delete(feature.id);
            }
            this.setState({
              expandedPrivilegeControls: new Set([...this.state.expandedPrivilegeControls])
            });
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "s"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          color: "subdued",
          paddingSize: "s",
          className: "subFeaturePanel"
        }, /*#__PURE__*/_react.default.createElement(_feature_table_expanded_row.FeatureTableExpandedRow, {
          feature: feature,
          privilegeIndex: this.props.privilegeIndex,
          onChange: this.props.onChange,
          privilegeCalculator: this.props.privilegeCalculator,
          selectedFeaturePrivileges: (_this$props$role$kiba = this.props.role.kibana[this.props.privilegeIndex].feature[feature.id]) !== null && _this$props$role$kiba !== void 0 ? _this$props$role$kiba : [],
          allSpacesSelected: this.props.allSpacesSelected,
          disabled: this.props.disabled,
          licenseAllowsSubFeatPrivCustomization: this.props.canCustomizeSubFeaturePrivileges
        })))));
      };
      const primaryFeaturePrivileges = feature.getPrimaryFeaturePrivileges();
      if (feature.reserved && primaryFeaturePrivileges.length === 0) {
        const buttonContent = /*#__PURE__*/_react.default.createElement(_feature_table_cell.FeatureTableCell, {
          className: "noSubFeaturePrivileges",
          feature: feature
        });
        const extraAction = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          style: {
            maxWidth: 200
          },
          size: 'xs',
          "data-test-subj": "reservedFeatureDescription"
        }, feature.reserved.description);
        return renderFeatureMarkup(buttonContent, extraAction, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "empty"
        }));
      }
      if (primaryFeaturePrivileges.length === 0) {
        return null;
      }
      const selectedPrivilegeId = this.props.privilegeCalculator.getDisplayedPrimaryFeaturePrivilegeId(feature.id, this.props.privilegeIndex, this.props.allSpacesSelected);
      const options = primaryFeaturePrivileges.filter(privilege => !privilege.disabled) // Don't show buttons for privileges that are disabled
      .map(privilege => {
        const disabledDueToSpaceSelection = privilege.requireAllSpaces && !this.props.allSpacesSelected;
        return {
          id: `${feature.id}_${privilege.id}`,
          label: privilege.name,
          isDisabled: this.props.disabled || disabledDueToSpaceSelection
        };
      });
      options.push({
        id: `${feature.id}_${_constants.NO_PRIVILEGE_VALUE}`,
        label: 'None',
        isDisabled: (_this$props$disabled = this.props.disabled) !== null && _this$props$disabled !== void 0 ? _this$props$disabled : false
      });
      let infoIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "empty",
        content: null
      });
      const arePrivilegeControlsCollapsed = !this.state.expandedPrivilegeControls.has(feature.id);
      if (arePrivilegeControlsCollapsed && this.props.privilegeCalculator.hasCustomizedSubFeaturePrivileges(feature.id, this.props.privilegeIndex, this.props.allSpacesSelected)) {
        infoIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: "iInCircle",
          content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRole.featureTable.privilegeCustomizationTooltip",
            defaultMessage: "Feature has customized sub-feature privileges. Expand this row for more information."
          })
        });
      }
      const hasSubFeaturePrivileges = feature.getSubFeaturePrivileges().length > 0;
      const buttonContent = /*#__PURE__*/_react.default.createElement(_feature_table_cell.FeatureTableCell, {
        className: (0, _classnames.default)({
          noSubFeaturePrivileges: !hasSubFeaturePrivileges
        }),
        feature: feature
      });
      const extraAction = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        name: `featurePrivilege_${feature.id}`,
        "data-test-subj": `primaryFeaturePrivilegeControl`,
        isFullWidth: true,
        options: options,
        idSelected: `${feature.id}_${selectedPrivilegeId !== null && selectedPrivilegeId !== void 0 ? selectedPrivilegeId : _constants.NO_PRIVILEGE_VALUE}`,
        onChange: this.onChange(feature.id),
        legend: _i18n.i18n.translate('xpack.security.management.editRole.featureTable.actionLegendText', {
          defaultMessage: '{featureName} feature privilege',
          values: {
            featureName: feature.name
          }
        }),
        style: {
          minWidth: 200
        }
      });
      return renderFeatureMarkup(buttonContent, extraAction, infoIcon);
    });
    (0, _defineProperty2.default)(this, "onChange", featureId => featurePrivilegeId => {
      const privilege = featurePrivilegeId.substr(`${featureId}_`.length);
      if (privilege === _constants.NO_PRIVILEGE_VALUE) {
        this.props.onChange(featureId, []);
      } else {
        this.props.onChange(featureId, [privilege]);
      }
    });
    (0, _defineProperty2.default)(this, "onChangeAllFeaturePrivileges", privilege => {
      if (privilege === _constants.NO_PRIVILEGE_VALUE) {
        this.props.onChangeAll([]);
      } else {
        this.props.onChangeAll([privilege]);
      }
    });
    (0, _defineProperty2.default)(this, "getCategoryHelpText", category => {
      if (category.id === 'management') {
        return _i18n.i18n.translate('xpack.security.management.editRole.featureTable.managementCategoryHelpText', {
          defaultMessage: 'Access to Stack Management is determined by both Elasticsearch and Kibana privileges, and cannot be explicitly disabled.'
        });
      }
    });
    props.kibanaPrivileges.getSecuredFeatures().filter(feature => feature.privileges != null || feature.reserved != null).forEach(feature => {
      if (!this.featureCategories.has(feature.category.id)) {
        this.featureCategories.set(feature.category.id, []);
      }
      this.featureCategories.get(feature.category.id).push(feature);
    });
    this.state = {
      expandedPrivilegeControls: new Set()
    };
  }
  render() {
    const basePrivileges = this.props.kibanaPrivileges.getBasePrivileges(this.props.role.kibana[this.props.privilegeIndex]);
    const accordions = [];
    this.featureCategories.forEach(featuresInCategory => {
      var _category$order;
      const {
        category
      } = featuresInCategory[0];
      const featureCount = featuresInCategory.length;
      const grantedCount = featuresInCategory.filter(feature => this.props.privilegeCalculator.getEffectivePrimaryFeaturePrivilege(feature.id, this.props.privilegeIndex, this.props.allSpacesSelected) != null).length;
      const canExpandCategory = true; // featuresInCategory.length > 1;

      const buttonContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": `featureCategoryButton_${category.id}`,
        alignItems: 'center',
        responsive: false,
        gutterSize: "m"
      }, category.euiIconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: category.euiIconType
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h4", {
        className: "eui-displayInlineBlock"
      }, category.label))));
      const label = _i18n.i18n.translate('xpack.security.management.editRole.featureTable.featureAccordionSwitchLabel', {
        defaultMessage: '{grantedCount} / {featureCount} {featureCount, plural, one {feature} other {features}} granted',
        values: {
          grantedCount,
          featureCount
        }
      });
      const extraAction = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        "aria-hidden": "true",
        color: 'subdued',
        "data-test-subj": "categoryLabel"
      }, label);
      const helpText = this.getCategoryHelpText(category);
      const accordion = /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: `featureCategory_${category.id}`,
        "data-test-subj": `featureCategory_${category.id}`,
        key: category.id,
        arrowDisplay: canExpandCategory ? 'left' : 'none',
        forceState: canExpandCategory ? undefined : 'closed',
        buttonContent: buttonContent,
        extraAction: canExpandCategory ? extraAction : undefined
      }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), helpText && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "iInCircle",
        size: "s"
      }, helpText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "s"
      }, featuresInCategory.map(feature => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: feature.id
      }, this.renderPrivilegeControlsForFeature(feature))))));
      accordions.push({
        order: (_category$order = category.order) !== null && _category$order !== void 0 ? _category$order : Number.MAX_SAFE_INTEGER,
        element: accordion
      });
    });
    accordions.sort((a1, a2) => a1.order - a2.order);
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: 'flexEnd'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("b", null, _i18n.i18n.translate('xpack.security.management.editRole.featureTable.featureVisibilityTitle', {
      defaultMessage: 'Customize feature privileges'
    })))), !this.props.disabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_change_all_privileges.ChangeAllPrivilegesControl, {
      privileges: basePrivileges,
      onChange: this.onChangeAllFeaturePrivileges
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: 'm'
    }), accordions.flatMap((a, idx) => [a.element, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      key: `accordion-hr-${idx}`,
      margin: 'm'
    })]));
  }
}
exports.FeatureTable = FeatureTable;
(0, _defineProperty2.default)(FeatureTable, "defaultProps", {
  privilegeIndex: -1,
  showLocks: true
});