"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roleMappingsManagementApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _readonly_badge = require("../badges/readonly_badge");
var _url_utils = require("../url_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const roleMappingsManagementApp = exports.roleMappingsManagementApp = Object.freeze({
  id: 'role_mappings',
  create({
    getStartServices
  }) {
    const title = _i18n.i18n.translate('xpack.security.management.roleMappingsTitle', {
      defaultMessage: 'Role Mappings'
    });
    return {
      id: this.id,
      order: 40,
      title,
      async mount({
        element,
        theme$,
        setBreadcrumbs,
        history
      }) {
        const [[core], {
          RoleMappingsGridPage
        }, {
          EditRoleMappingPage
        }, {
          RoleMappingsAPIClient
        }, {
          RolesAPIClient
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./role_mappings_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_role_mapping'))), Promise.resolve().then(() => _interopRequireWildcard(require('./role_mappings_api_client'))), Promise.resolve().then(() => _interopRequireWildcard(require('../roles')))]);
        core.chrome.docTitle.change(title);
        const roleMappingsAPIClient = new RoleMappingsAPIClient(core.http);
        const EditRoleMappingsPageWithBreadcrumbs = ({
          action
        }) => {
          const {
            name
          } = (0, _reactRouterDom.useParams)();

          // Additional decoding is a workaround for a bug in react-router's version of the `history` module.
          // See https://github.com/elastic/kibana/issues/82440
          const decodedName = name ? (0, _url_utils.tryDecodeURIComponent)(name) : undefined;
          const breadcrumbObj = action === 'edit' && name && decodedName ? {
            text: decodedName,
            href: `/edit/${encodeURIComponent(name)}`
          } : {
            text: _i18n.i18n.translate('xpack.security.roleMappings.createBreadcrumb', {
              defaultMessage: 'Create'
            })
          };
          return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
            text: breadcrumbObj.text,
            href: breadcrumbObj.href
          }, /*#__PURE__*/_react.default.createElement(EditRoleMappingPage, {
            action: action,
            name: decodedName,
            roleMappingsAPI: roleMappingsAPIClient,
            rolesAPIClient: new RolesAPIClient(core.http),
            notifications: core.notifications,
            docLinks: core.docLinks,
            history: history,
            readOnly: !core.application.capabilities.role_mappings.save
          }));
        };
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: core
        }, /*#__PURE__*/_react.default.createElement(core.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
          theme$: theme$
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
          history: history
        }, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
          "data-test-subj": "readOnlyBadge",
          featureId: "role_mappings",
          tooltip: _i18n.i18n.translate('xpack.security.management.roleMappings.readonlyTooltip', {
            defaultMessage: 'Unable to create or edit role mappings'
          })
        }), /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(core.chrome, setBreadcrumbs)
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: title,
          href: "/"
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['/', ''],
          exact: true
        }, /*#__PURE__*/_react.default.createElement(RoleMappingsGridPage, {
          notifications: core.notifications,
          rolesAPIClient: new RolesAPIClient(core.http),
          roleMappingsAPI: roleMappingsAPIClient,
          docLinks: core.docLinks,
          history: history,
          navigateToApp: core.application.navigateToApp,
          readOnly: !core.application.capabilities.role_mappings.save
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/edit/:name?"
        }, /*#__PURE__*/_react.default.createElement(EditRoleMappingsPageWithBreadcrumbs, {
          action: "edit"
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/clone/:name"
        }, /*#__PURE__*/_react.default.createElement(EditRoleMappingsPageWithBreadcrumbs, {
          action: "clone"
        })))))))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});