"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleGroupEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./rule_group_editor.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _add_rule_button = require("./add_rule_button");
var _field_rule_editor = require("./field_rule_editor");
var _rule_group_title = require("./rule_group_title");
var _is_rule_group = require("../services/is_rule_group");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleGroupEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderSubRules", () => {
      return this.props.rule.getRules().map((subRule, subRuleIndex, rules) => {
        const isLastRule = subRuleIndex === rules.length - 1;
        const divider = isLastRule ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
          margin: "m"
        }));
        if ((0, _is_rule_group.isRuleGroup)(subRule)) {
          return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            key: subRuleIndex
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RuleGroupEditor, {
            rule: subRule,
            parentRule: this.props.rule,
            allowAdd: this.props.allowAdd,
            ruleDepth: this.props.ruleDepth + 1,
            onChange: updatedSubRule => {
              const updatedRule = this.props.rule.clone();
              updatedRule.replaceRule(subRuleIndex, updatedSubRule);
              this.props.onChange(updatedRule);
            },
            onDelete: () => {
              const updatedRule = this.props.rule.clone();
              updatedRule.removeRule(subRuleIndex);
              this.props.onChange(updatedRule);
            },
            readOnly: this.props.readOnly
          })), divider);
        }
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          key: subRuleIndex
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_rule_editor.FieldRuleEditor, {
          rule: subRule,
          onChange: updatedSubRule => {
            const updatedRule = this.props.rule.clone();
            updatedRule.replaceRule(subRuleIndex, updatedSubRule);
            this.props.onChange(updatedRule);
          },
          onDelete: () => {
            const updatedRule = this.props.rule.clone();
            updatedRule.removeRule(subRuleIndex);
            this.props.onChange(updatedRule);
          },
          readOnly: this.props.readOnly
        })), divider);
      });
    });
    (0, _defineProperty2.default)(this, "onAddRuleClick", newRule => {
      const updatedRule = this.props.rule.clone();
      updatedRule.addRule(newRule);
      this.props.onChange(updatedRule);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      className: `secRoleMapping__ruleEditorGroup--${this.props.ruleDepth % 2 ? 'odd' : 'even'}`,
      hasBorder: true,
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_rule_group_title.RuleGroupTitle, {
      rule: this.props.rule,
      onChange: this.props.onChange,
      parentRule: this.props.parentRule,
      readOnly: this.props.readOnly
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, this.props.readOnly === false && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      onClick: this.props.onDelete,
      size: "s",
      iconType: "trash",
      "data-test-subj": "deleteRuleGroupButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.deleteRuleGroupButton",
      defaultMessage: "Delete"
    }))))), this.renderSubRules(), this.props.allowAdd && this.props.readOnly === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_rule_button.AddRuleButton, {
      onClick: this.onAddRuleClick
    }))));
  }
}
exports.RuleGroupEditor = RuleGroupEditor;
(0, _defineProperty2.default)(RuleGroupEditor, "defaultProps", {
  readOnly: false
});