"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyFlyout = void 0;
exports.mapCreateApiKeyValues = mapCreateApiKeyValues;
exports.mapUpdateApiKeyValues = mapUpdateApiKeyValues;
var _eui = require("@elastic/eui");
var _formik = require("formik");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireWildcard(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _api_keys_grid_page = require("./api_keys_grid_page");
var _doc_link = require("../../../components/doc_link");
var _form_field = require("../../../components/form_field");
var _form_row = require("../../../components/form_row");
var _use_current_user = require("../../../components/use_current_user");
var _use_html_id = require("../../../components/use_html_id");
var _use_initial_focus = require("../../../components/use_initial_focus");
var _roles_api_client = require("../../roles/roles_api_client");
var _api_keys_api_client = require("../api_keys_api_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TypeLabel = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.security.accountManagement.apiKeyFlyout.typeLabel",
  defaultMessage: "Type"
});
const NameLabel = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.security.accountManagement.apiKeyFlyout.nameLabel",
  defaultMessage: "Name"
});
const invalidJsonError = _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.invalidJsonError', {
  defaultMessage: 'Enter valid JSON.'
});
const defaultInitialValues = {
  name: '',
  type: 'rest',
  expiration: '',
  includeMetadata: false,
  metadata: '{}',
  customExpiration: false,
  customPrivileges: false,
  access: JSON.stringify({
    search: [{
      names: ['*']
    }],
    replication: [{
      names: ['*']
    }]
  }, null, 2),
  role_descriptors: '{}'
};
const ApiKeyFlyout = ({
  onSuccess,
  onCancel,
  apiKey,
  canManageCrossClusterApiKeys = false,
  readOnly = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services
  } = (0, _public.useKibana)();
  const isDarkMode = (0, _public.useDarkMode)();
  const {
    value: currentUser,
    loading: isLoadingCurrentUser
  } = (0, _use_current_user.useCurrentUser)();
  const [{
    value: roles,
    loading: isLoadingRoles
  }, getRoles] = (0, _useAsyncFn.default)(() => new _roles_api_client.RolesAPIClient(services.http).getRoles(), [services.http]);
  const [responseError, setResponseError] = (0, _react.useState)(undefined);
  const formik = (0, _formik.useFormik)({
    onSubmit: async values => {
      try {
        if (apiKey) {
          const updateApiKeyResponse = await new _api_keys_api_client.APIKeysAPIClient(services.http).updateApiKey(mapUpdateApiKeyValues(apiKey.type, apiKey.id, values));
          onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(updateApiKeyResponse);
        } else {
          const createApiKeyResponse = await new _api_keys_api_client.APIKeysAPIClient(services.http).createApiKey(mapCreateApiKeyValues(values));
          onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(createApiKeyResponse);
        }
        setResponseError(undefined);
      } catch (error) {
        setResponseError(error.body);
        throw error;
      }
    },
    initialValues: apiKey ? mapApiKeyFormValues(apiKey) : defaultInitialValues
  });
  (0, _react.useEffect)(() => {
    getRoles();
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  (0, _react.useEffect)(() => {
    if (currentUser && roles) {
      const userPermissions = currentUser.roles.reduce((accumulator, roleName) => {
        const role = roles.find(r => r.name === roleName);
        if (role) {
          accumulator[role.name] = role.elasticsearch;
        }
        return accumulator;
      }, {});
      if (!formik.touched.role_descriptors && !apiKey) {
        formik.setFieldValue('role_descriptors', JSON.stringify(userPermissions, null, 2));
      }
    }
  }, [currentUser, roles]); // eslint-disable-line react-hooks/exhaustive-deps

  const isLoading = isLoadingCurrentUser || isLoadingRoles;
  const isOwner = currentUser && apiKey ? currentUser.username === apiKey.username : false;
  const hasExpired = apiKey ? apiKey.expiration && (0, _momentTimezone.default)(apiKey.expiration).isBefore() : false;
  const canEdit = isOwner && !hasExpired;
  const firstFieldRef = (0, _use_initial_focus.useInitialFocus)([isLoading]);
  const titleId = (0, _use_html_id.useHtmlId)('formFlyout', 'title');
  const isSubmitButtonHidden = readOnly || apiKey && !canEdit;
  const isSubmitDisabled = isLoading || formik.submitCount > 0 && !formik.isValid || readOnly || apiKey && !canEdit;
  const title = apiKey ? readOnly || !canEdit ? _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.viewTitle', {
    defaultMessage: `API key details`
  }) : _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.updateTitle', {
    defaultMessage: `Update API key`
  }) : _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.createTitle', {
    defaultMessage: `Create API key`
  });
  const submitButtonText = apiKey ? _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.updateSubmitButton', {
    defaultMessage: `{isSubmitting, select, true{Updating API key…} other{Update API key}}`,
    values: {
      isSubmitting: formik.isSubmitting
    }
  }) : _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.createSubmitButton', {
    defaultMessage: `{isSubmitting, select, true{Creating API key…} other{Create API key}}`,
    values: {
      isSubmitting: formik.isSubmitting
    }
  });
  let expirationDate;
  if (formik.values.customExpiration) {
    expirationDate = new Date();
    expirationDate.setDate(expirationDate.getDate() + parseInt(formik.values.expiration, 10));
  }
  return /*#__PURE__*/_react.default.createElement(_formik.FormikProvider, {
    value: formik
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCancel,
    "aria-labelledby": titleId,
    size: "m",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_formik.Form, {
    onSubmit: formik.handleSubmit,
    style: {
      display: 'flex',
      flexDirection: 'column',
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: titleId
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading
  }, responseError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.responseErrorTitle",
      defaultMessage: "Error creating API key"
    })
  }, responseError.message), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), apiKey && !readOnly ? !isOwner ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.readonlyOwnedByOtherUserWarning",
      defaultMessage: "You can\u2019t update this API key. It belongs to another user."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : hasExpired ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.readonlyExpiredWarning",
      defaultMessage: "This API key has expired. You can no longer update it."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null : null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, apiKey ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.overviewLabel",
    defaultMessage: "Overview"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(NameLabel, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, apiKey.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.ownerLabel",
    defaultMessage: "Owner"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, apiKey.username)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(TypeLabel, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.ApiKeyBadge, {
    type: apiKey.type
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.createdLabel",
    defaultMessage: "Created"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.TimeToolTip, {
    timestamp: apiKey.creation
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.statusLabel",
    defaultMessage: "Status"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.ApiKeyStatus, {
    expiration: apiKey.expiration
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "gear"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.setup.title",
    defaultMessage: "Setup"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.setup.description",
    defaultMessage: "Basic configuration details to create your API key."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(NameLabel, null),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    name: "name",
    inputRef: firstFieldRef,
    "data-test-subj": "apiKeyNameInput",
    disabled: readOnly || !!apiKey,
    validate: {
      required: _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.nameRequired', {
        defaultMessage: 'Enter a name.'
      })
    },
    fullWidth: true
  })), canManageCrossClusterApiKeys ? /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    name: "type",
    label: /*#__PURE__*/_react.default.createElement(TypeLabel, null),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "rest",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.restTypeLabel",
      defaultMessage: "User API key"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.restTypeDescription",
      defaultMessage: "Allow external services to access the Elastic Stack on your behalf."
    }))),
    onChange: () => formik.setFieldValue('type', 'rest'),
    checked: formik.values.type === 'rest'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "cross_cluster",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.crossClusterTypeLabel",
      defaultMessage: "Cross-cluster API key"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.crossClusterTypeDescription",
      defaultMessage: "Allow other clusters to connect to this cluster."
    }))),
    onChange: () => formik.setFieldValue('type', 'cross_cluster'),
    checked: formik.values.type === 'cross_cluster'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(TypeLabel, null)
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.ApiKeyBadge, {
    type: "rest"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !apiKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingRight: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "apiKeyCustomExpirationSwitch",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.applyExpirationDateLabel",
      defaultMessage: "Apply expiration date"
    }))),
    checked: Boolean(formik.values.customExpiration),
    disabled: readOnly || !!apiKey,
    onChange: e => formik.setFieldValue('customExpiration', e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.expiresFieldHelpText",
    defaultMessage: "Setting an expiration date is a security best practice. Defaults to no expiration."
  })))), formik.values.customExpiration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.expirationHelpText",
      defaultMessage: "This API Key will expire on {expirationDate}",
      values: {
        expirationDate: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
          year: "numeric",
          month: "long",
          day: "numeric",
          value: expirationDate
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _eui.EuiFieldNumber,
    name: "expiration",
    min: 0,
    append: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.expirationUnit', {
      defaultMessage: 'days'
    }),
    validate: {
      min: {
        value: 1,
        message: _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.expirationRequired', {
          defaultMessage: 'Enter a valid duration or disable this option.'
        })
      }
    },
    disabled: readOnly || !!apiKey,
    "data-test-subj": "apiKeyCustomExpirationInput"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), formik.values.type === 'cross_cluster' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingRight: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "lock"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.accessPermissions.title', {
    defaultMessage: 'Access Permissions'
  })))))), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    "data-test-subj": "apiKeysAccessCodeEditor",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.accessLabel",
      defaultMessage: "Access"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-cross-cluster-api-key.html#security-api-create-cross-cluster-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.accessHelpText",
      defaultMessage: "Learn how to structure access permissions."
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _codeEditor.CodeEditorField,
    name: "access",
    "aria-label": _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.accessCodeEditor', {
      defaultMessage: 'Code editor for access permissions'
    }),
    value: formik.values.access,
    options: {
      readOnly: readOnly || apiKey && !canEdit
    },
    onChange: value => formik.setFieldValue('access', value),
    validate: value => {
      if (!value) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.accessRequired', {
          defaultMessage: 'Enter access permissions or disable this option.'
        });
      }
      try {
        JSON.parse(value);
      } catch (e) {
        return invalidJsonError;
      }
    },
    fullWidth: true,
    languageId: "xjson",
    height: 200,
    useDarkTheme: isDarkMode
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingRight: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.privileges.title', {
      defaultMessage: 'Control security privileges'
    }))),
    checked: formik.values.customPrivileges,
    "data-test-subj": "apiKeysRoleDescriptorsSwitch",
    onChange: e => formik.setFieldValue('customPrivileges', e.target.checked),
    disabled: readOnly || apiKey && !canEdit
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.privileges.description', {
    defaultMessage: 'Control access to specific Elasticsearch APIs and resources using predefined roles or custom privileges per API key.'
  })))), formik.values.customPrivileges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-api-key.html#security-api-create-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.roleDescriptorsHelpText",
      defaultMessage: "Learn how to structure role descriptors."
    })),
    fullWidth: true,
    "data-test-subj": "apiKeysRoleDescriptorsCodeEditor"
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _codeEditor.CodeEditorField,
    name: "role_descriptors",
    "aria-label": _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.roleDescriptorsCodeEditor', {
      defaultMessage: 'Code editor for role descriptors of this API key'
    }),
    value: formik.values.role_descriptors,
    options: {
      readOnly: readOnly || apiKey && !canEdit
    },
    onChange: value => formik.setFieldValue('role_descriptors', value),
    validate: value => {
      if (!value) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.roleDescriptorsRequired', {
          defaultMessage: 'Enter role descriptors or disable this option.'
        });
      }
      try {
        JSON.parse(value);
      } catch (e) {
        return invalidJsonError;
      }
    },
    fullWidth: true,
    languageId: "xjson",
    height: 200,
    useDarkTheme: isDarkMode
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingRight: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.metadata.title",
      defaultMessage: "Add metadata"
    }))),
    "data-test-subj": "apiKeysMetadataSwitch",
    checked: formik.values.includeMetadata,
    disabled: readOnly || apiKey && !canEdit,
    onChange: e => formik.setFieldValue('includeMetadata', e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accountManagement.apiKeyFlyout.metadata.description",
    defaultMessage: "Use configurable key-value pairs to add information about the API key or customize Elasticsearch resource access."
  })))), formik.values.includeMetadata && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    "data-test-subj": "apiKeysMetadataCodeEditor",
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-api-key.html#security-api-create-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.metadataHelpText",
      defaultMessage: "Learn how to structure metadata."
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _codeEditor.CodeEditorField,
    name: "metadata",
    "aria-label": _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.metadataCodeEditor', {
      defaultMessage: 'Code editor for arbitrary metadata associated with the API key'
    }),
    options: {
      readOnly: readOnly || apiKey && !canEdit
    },
    value: formik.values.metadata,
    onChange: value => formik.setFieldValue('metadata', value),
    validate: value => {
      if (!value) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.metadataRequired', {
          defaultMessage: 'Enter metadata or disable this option.'
        });
      }
      try {
        JSON.parse(value);
      } catch (e) {
        return invalidJsonError;
      }
    },
    fullWidth: true,
    languageId: "xjson",
    height: 200,
    useDarkTheme: isDarkMode
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "formFlyoutCancelButton",
    flush: "right",
    isDisabled: isLoading,
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.formFlyout.cancelButton",
    defaultMessage: "Cancel"
  }))), !isSubmitButtonHidden && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "formFlyoutSubmitButton",
    isLoading: formik.isSubmitting,
    isDisabled: isSubmitDisabled,
    fill: true,
    type: "submit"
  }, submitButtonText)))))));
};
exports.ApiKeyFlyout = ApiKeyFlyout;
function mapCreateApiKeyValues(values) {
  const {
    type,
    name
  } = values;
  const expiration = values.customExpiration ? `${values.expiration}d` : undefined;
  const metadata = values.includeMetadata ? JSON.parse(values.metadata) : '{}';
  if (type === 'cross_cluster') {
    return {
      type,
      name,
      expiration,
      metadata,
      access: JSON.parse(values.access)
    };
  }
  return {
    name,
    expiration,
    metadata,
    role_descriptors: values.customPrivileges ? JSON.parse(values.role_descriptors) : '{}'
  };
}
function mapUpdateApiKeyValues(type, id, values) {
  const metadata = values.includeMetadata ? JSON.parse(values.metadata) : '{}';
  if (type === 'cross_cluster') {
    return {
      type,
      id,
      metadata,
      access: JSON.parse(values.access)
    };
  }
  return {
    id,
    metadata,
    role_descriptors: values.customPrivileges ? JSON.parse(values.role_descriptors) : '{}'
  };
}

/**
 * Maps data from the selected API key to pre-populate the form
 */
function mapApiKeyFormValues(apiKey) {
  const includeMetadata = Object.keys(apiKey.metadata).length > 0;
  const customPrivileges = apiKey.type !== 'cross_cluster' ? Object.keys(apiKey.role_descriptors).length > 0 : false;
  return {
    name: apiKey.name,
    type: apiKey.type,
    customExpiration: !!apiKey.expiration,
    expiration: !!apiKey.expiration ? apiKey.expiration.toString() : '',
    includeMetadata,
    metadata: includeMetadata ? JSON.stringify(apiKey.metadata, null, 2) : '{}',
    customPrivileges,
    role_descriptors: customPrivileges ? JSON.stringify(apiKey.type !== 'cross_cluster' && apiKey.role_descriptors, null, 2) : '{}',
    access: apiKey.type === 'cross_cluster' ? JSON.stringify(apiKey.access, null, 2) : '{}'
  };
}